/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeQueryRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, DescribeQueryRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(DescribeQueryRequest.getter(DescribeQueryRequest::eventDataStore)).setter(DescribeQueryRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(DescribeQueryRequest.getter(DescribeQueryRequest::queryId)).setter(DescribeQueryRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAlias").getter(DescribeQueryRequest.getter(DescribeQueryRequest::queryAlias)).setter(DescribeQueryRequest.setter(Builder::queryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()}).build();
    private static final SdkField<String> REFRESH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshId").getter(DescribeQueryRequest.getter(DescribeQueryRequest::refreshId)).setter(DescribeQueryRequest.setter(Builder::refreshId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshId").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreOwnerAccountId").getter(DescribeQueryRequest.getter(DescribeQueryRequest::eventDataStoreOwnerAccountId)).setter(DescribeQueryRequest.setter(Builder::eventDataStoreOwnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD, QUERY_ID_FIELD, QUERY_ALIAS_FIELD, REFRESH_ID_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeQueryRequest.memberNameToFieldInitializer();
    private final String eventDataStore;
    private final String queryId;
    private final String queryAlias;
    private final String refreshId;
    private final String eventDataStoreOwnerAccountId;

    private DescribeQueryRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.queryId = builder.queryId;
        this.queryAlias = builder.queryAlias;
        this.refreshId = builder.refreshId;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    @Deprecated
    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryAlias() {
        return this.queryAlias;
    }

    public final String refreshId() {
        return this.refreshId;
    }

    public final String eventDataStoreOwnerAccountId() {
        return this.eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreOwnerAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryRequest)) {
            return false;
        }
        DescribeQueryRequest other = (DescribeQueryRequest)((Object)obj);
        return Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryAlias(), other.queryAlias()) && Objects.equals(this.refreshId(), other.refreshId()) && Objects.equals(this.eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeQueryRequest").add("EventDataStore", (Object)this.eventDataStore()).add("QueryId", (Object)this.queryId()).add("QueryAlias", (Object)this.queryAlias()).add("RefreshId", (Object)this.refreshId()).add("EventDataStoreOwnerAccountId", (Object)this.eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryAlias": {
                return Optional.ofNullable(clazz.cast(this.queryAlias()));
            }
            case "RefreshId": {
                return Optional.ofNullable(clazz.cast(this.refreshId()));
            }
            case "EventDataStoreOwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreOwnerAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryAlias", QUERY_ALIAS_FIELD);
        map.put("RefreshId", REFRESH_ID_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryRequest, T> g) {
        return obj -> g.apply((DescribeQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventDataStore;
        private String queryId;
        private String queryAlias;
        private String refreshId;
        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryRequest model) {
            super(model);
            this.eventDataStore(model.eventDataStore);
            this.queryId(model.queryId);
            this.queryAlias(model.queryAlias);
            this.refreshId(model.refreshId);
            this.eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        @Deprecated
        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        @Deprecated
        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        @Deprecated
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryAlias() {
            return this.queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        public final String getRefreshId() {
            return this.refreshId;
        }

        public final void setRefreshId(String refreshId) {
            this.refreshId = refreshId;
        }

        @Override
        public final Builder refreshId(String refreshId) {
            this.refreshId = refreshId;
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return this.eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeQueryRequest build() {
            return new DescribeQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeQueryRequest> {
        @Deprecated
        public Builder eventDataStore(String var1);

        public Builder queryId(String var1);

        public Builder queryAlias(String var1);

        public Builder refreshId(String var1);

        public Builder eventDataStoreOwnerAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

