/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.QueryParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, StartQueryRequest> {
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatement").getter(StartQueryRequest.getter(StartQueryRequest::queryStatement)).setter(StartQueryRequest.setter(Builder::queryStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()}).build();
    private static final SdkField<String> DELIVERY_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Uri").getter(StartQueryRequest.getter(StartQueryRequest::deliveryS3Uri)).setter(StartQueryRequest.setter(Builder::deliveryS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Uri").build()}).build();
    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAlias").getter(StartQueryRequest.getter(StartQueryRequest::queryAlias)).setter(StartQueryRequest.setter(Builder::queryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()}).build();
    private static final SdkField<List<String>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryParameters").getter(StartQueryRequest.getter(StartQueryRequest::queryParameters)).setter(StartQueryRequest.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreOwnerAccountId").getter(StartQueryRequest.getter(StartQueryRequest::eventDataStoreOwnerAccountId)).setter(StartQueryRequest.setter(Builder::eventDataStoreOwnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATEMENT_FIELD, DELIVERY_S3_URI_FIELD, QUERY_ALIAS_FIELD, QUERY_PARAMETERS_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartQueryRequest.memberNameToFieldInitializer();
    private final String queryStatement;
    private final String deliveryS3Uri;
    private final String queryAlias;
    private final List<String> queryParameters;
    private final String eventDataStoreOwnerAccountId;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryStatement = builder.queryStatement;
        this.deliveryS3Uri = builder.deliveryS3Uri;
        this.queryAlias = builder.queryAlias;
        this.queryParameters = builder.queryParameters;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    public final String queryStatement() {
        return this.queryStatement;
    }

    public final String deliveryS3Uri() {
        return this.deliveryS3Uri;
    }

    public final String queryAlias() {
        return this.queryAlias;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<String> queryParameters() {
        return this.queryParameters;
    }

    public final String eventDataStoreOwnerAccountId() {
        return this.eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreOwnerAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest)((Object)obj);
        return Objects.equals(this.queryStatement(), other.queryStatement()) && Objects.equals(this.deliveryS3Uri(), other.deliveryS3Uri()) && Objects.equals(this.queryAlias(), other.queryAlias()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"StartQueryRequest").add("QueryStatement", (Object)this.queryStatement()).add("DeliveryS3Uri", (Object)this.deliveryS3Uri()).add("QueryAlias", (Object)this.queryAlias()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("EventDataStoreOwnerAccountId", (Object)this.eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryStatement": {
                return Optional.ofNullable(clazz.cast(this.queryStatement()));
            }
            case "DeliveryS3Uri": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Uri()));
            }
            case "QueryAlias": {
                return Optional.ofNullable(clazz.cast(this.queryAlias()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "EventDataStoreOwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreOwnerAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("DeliveryS3Uri", DELIVERY_S3_URI_FIELD);
        map.put("QueryAlias", QUERY_ALIAS_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String queryStatement;
        private String deliveryS3Uri;
        private String queryAlias;
        private List<String> queryParameters = DefaultSdkAutoConstructList.getInstance();
        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            this.queryStatement(model.queryStatement);
            this.deliveryS3Uri(model.deliveryS3Uri);
            this.queryAlias(model.queryAlias);
            this.queryParameters(model.queryParameters);
            this.eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        public final String getQueryStatement() {
            return this.queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final String getDeliveryS3Uri() {
            return this.deliveryS3Uri;
        }

        public final void setDeliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
        }

        @Override
        public final Builder deliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
            return this;
        }

        public final String getQueryAlias() {
            return this.queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        public final Collection<String> getQueryParameters() {
            if (this.queryParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryParameters;
        }

        public final void setQueryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(String ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return this.eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryRequest> {
        public Builder queryStatement(String var1);

        public Builder deliveryS3Uri(String var1);

        public Builder queryAlias(String var1);

        public Builder queryParameters(Collection<String> var1);

        public Builder queryParameters(String ... var1);

        public Builder eventDataStoreOwnerAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

