/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.RefreshSchedule;
import software.amazon.awssdk.services.cloudtrail.model.RequestWidget;
import software.amazon.awssdk.services.cloudtrail.model.RequestWidgetListCopier;
import software.amazon.awssdk.services.cloudtrail.model.Tag;
import software.amazon.awssdk.services.cloudtrail.model.TagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDashboardRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, CreateDashboardRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDashboardRequest.getter(CreateDashboardRequest::name)).setter(CreateDashboardRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshSchedule").getter(CreateDashboardRequest.getter(CreateDashboardRequest::refreshSchedule)).setter(CreateDashboardRequest.setter(Builder::refreshSchedule)).constructor(RefreshSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()}).build();
    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsList").getter(CreateDashboardRequest.getter(CreateDashboardRequest::tagsList)).setter(CreateDashboardRequest.setter(Builder::tagsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(CreateDashboardRequest.getter(CreateDashboardRequest::terminationProtectionEnabled)).setter(CreateDashboardRequest.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final SdkField<List<RequestWidget>> WIDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Widgets").getter(CreateDashboardRequest.getter(CreateDashboardRequest::widgets)).setter(CreateDashboardRequest.setter(Builder::widgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestWidget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REFRESH_SCHEDULE_FIELD, TAGS_LIST_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, WIDGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDashboardRequest.memberNameToFieldInitializer();
    private final String name;
    private final RefreshSchedule refreshSchedule;
    private final List<Tag> tagsList;
    private final Boolean terminationProtectionEnabled;
    private final List<RequestWidget> widgets;

    private CreateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.refreshSchedule = builder.refreshSchedule;
        this.tagsList = builder.tagsList;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.widgets = builder.widgets;
    }

    public final String name() {
        return this.name;
    }

    public final RefreshSchedule refreshSchedule() {
        return this.refreshSchedule;
    }

    public final boolean hasTagsList() {
        return this.tagsList != null && !(this.tagsList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagsList() {
        return this.tagsList;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    public final boolean hasWidgets() {
        return this.widgets != null && !(this.widgets instanceof SdkAutoConstructList);
    }

    public final List<RequestWidget> widgets() {
        return this.widgets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsList() ? this.tagsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWidgets() ? this.widgets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.refreshSchedule(), other.refreshSchedule()) && this.hasTagsList() == other.hasTagsList() && Objects.equals(this.tagsList(), other.tagsList()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled()) && this.hasWidgets() == other.hasWidgets() && Objects.equals(this.widgets(), other.widgets());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDashboardRequest").add("Name", (Object)this.name()).add("RefreshSchedule", (Object)this.refreshSchedule()).add("TagsList", this.hasTagsList() ? this.tagsList() : null).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).add("Widgets", this.hasWidgets() ? this.widgets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RefreshSchedule": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedule()));
            }
            case "TagsList": {
                return Optional.ofNullable(clazz.cast(this.tagsList()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
            case "Widgets": {
                return Optional.ofNullable(clazz.cast(this.widgets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("TagsList", TAGS_LIST_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardRequest, T> g) {
        return obj -> g.apply((CreateDashboardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String name;
        private RefreshSchedule refreshSchedule;
        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();
        private Boolean terminationProtectionEnabled;
        private List<RequestWidget> widgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardRequest model) {
            super(model);
            this.name(model.name);
            this.refreshSchedule(model.refreshSchedule);
            this.tagsList(model.tagsList);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
            this.widgets(model.widgets);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return this.refreshSchedule != null ? this.refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final List<Tag.Builder> getTagsList() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tagsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag ... tagsList) {
            this.tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder> ... tagsList) {
            this.tagsList(Stream.of(tagsList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final List<RequestWidget.Builder> getWidgets() {
            List<RequestWidget.Builder> result = RequestWidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<RequestWidget.BuilderImpl> widgets) {
            this.widgets = RequestWidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<RequestWidget> widgets) {
            this.widgets = RequestWidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(RequestWidget ... widgets) {
            this.widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<RequestWidget.Builder> ... widgets) {
            this.widgets(Stream.of(widgets).map(c -> (RequestWidget)((RequestWidget.Builder)RequestWidget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDashboardRequest build() {
            return new CreateDashboardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDashboardRequest> {
        public Builder name(String var1);

        public Builder refreshSchedule(RefreshSchedule var1);

        default public Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return this.refreshSchedule((RefreshSchedule)((RefreshSchedule.Builder)RefreshSchedule.builder().applyMutation(refreshSchedule)).build());
        }

        public Builder tagsList(Collection<Tag> var1);

        public Builder tagsList(Tag ... var1);

        public Builder tagsList(Consumer<Tag.Builder> ... var1);

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder widgets(Collection<RequestWidget> var1);

        public Builder widgets(RequestWidget ... var1);

        public Builder widgets(Consumer<RequestWidget.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

