/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.InsightType;
import software.amazon.awssdk.services.cloudtrail.model.SourceEventCategoriesCopier;
import software.amazon.awssdk.services.cloudtrail.model.SourceEventCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightSelector> {
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightType").getter(InsightSelector.getter(InsightSelector::insightTypeAsString)).setter(InsightSelector.setter(Builder::insightType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventCategories").getter(InsightSelector.getter(InsightSelector::eventCategoriesAsStrings)).setter(InsightSelector.setter(Builder::eventCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_TYPE_FIELD, EVENT_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String insightType;
    private final List<String> eventCategories;

    private InsightSelector(BuilderImpl builder) {
        this.insightType = builder.insightType;
        this.eventCategories = builder.eventCategories;
    }

    public final InsightType insightType() {
        return InsightType.fromValue(this.insightType);
    }

    public final String insightTypeAsString() {
        return this.insightType;
    }

    public final List<SourceEventCategory> eventCategories() {
        return SourceEventCategoriesCopier.copyStringToEnum(this.eventCategories);
    }

    public final boolean hasEventCategories() {
        return this.eventCategories != null && !(this.eventCategories instanceof SdkAutoConstructList);
    }

    public final List<String> eventCategoriesAsStrings() {
        return this.eventCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventCategories() ? this.eventCategoriesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightSelector)) {
            return false;
        }
        InsightSelector other = (InsightSelector)obj;
        return Objects.equals(this.insightTypeAsString(), other.insightTypeAsString()) && this.hasEventCategories() == other.hasEventCategories() && Objects.equals(this.eventCategoriesAsStrings(), other.eventCategoriesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InsightSelector").add("InsightType", (Object)this.insightTypeAsString()).add("EventCategories", this.hasEventCategories() ? this.eventCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightType": {
                return Optional.ofNullable(clazz.cast(this.insightTypeAsString()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategoriesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InsightType", INSIGHT_TYPE_FIELD);
        map.put("EventCategories", EVENT_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightSelector, T> g) {
        return obj -> g.apply((InsightSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightType;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightSelector model) {
            this.insightType(model.insightType);
            this.eventCategoriesWithStrings(model.eventCategories);
        }

        public final String getInsightType() {
            return this.insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final Collection<String> getEventCategories() {
            if (this.eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventCategories;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = SourceEventCategoriesCopier.copy(eventCategories);
        }

        @Override
        public final Builder eventCategoriesWithStrings(Collection<String> eventCategories) {
            this.eventCategories = SourceEventCategoriesCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesWithStrings(String ... eventCategories) {
            this.eventCategoriesWithStrings(Arrays.asList(eventCategories));
            return this;
        }

        @Override
        public final Builder eventCategories(Collection<SourceEventCategory> eventCategories) {
            this.eventCategories = SourceEventCategoriesCopier.copyEnumToString(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(SourceEventCategory ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public InsightSelector build() {
            return new InsightSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightSelector> {
        public Builder insightType(String var1);

        public Builder insightType(InsightType var1);

        public Builder eventCategoriesWithStrings(Collection<String> var1);

        public Builder eventCategoriesWithStrings(String ... var1);

        public Builder eventCategories(Collection<SourceEventCategory> var1);

        public Builder eventCategories(SourceEventCategory ... var1);
    }
}

