/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ImportsListItem;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;

public class ListImportsPublisher
implements SdkPublisher<ListImportsResponse> {
    private final CloudTrailAsyncClient client;
    private final ListImportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportsPublisher(CloudTrailAsyncClient client, ListImportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportsPublisher(CloudTrailAsyncClient client, ListImportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportsListItem> imports() {
        return this.flatMapIterable(response -> response.imports());
    }

    private class ListImportsResponseFetcher
    implements AsyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportsResponse> nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsPublisher.this.client.listImports(ListImportsPublisher.this.firstRequest);
            }
            return ListImportsPublisher.this.client.listImports((ListImportsRequest)((Object)ListImportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

