/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnerEventSourcesRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, ListPartnerEventSourcesRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(ListPartnerEventSourcesRequest.getter(ListPartnerEventSourcesRequest::namePrefix)).setter(ListPartnerEventSourcesRequest.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPartnerEventSourcesRequest.getter(ListPartnerEventSourcesRequest::nextToken)).setter(ListPartnerEventSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListPartnerEventSourcesRequest.getter(ListPartnerEventSourcesRequest::limit)).setter(ListPartnerEventSourcesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPartnerEventSourcesRequest.memberNameToFieldInitializer();
    private final String namePrefix;
    private final String nextToken;
    private final Integer limit;

    private ListPartnerEventSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerEventSourcesRequest)) {
            return false;
        }
        ListPartnerEventSourcesRequest other = (ListPartnerEventSourcesRequest)((Object)obj);
        return Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartnerEventSourcesRequest").add("NamePrefix", (Object)this.namePrefix()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerEventSourcesRequest, T> g) {
        return obj -> g.apply((ListPartnerEventSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String namePrefix;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerEventSourcesRequest model) {
            super(model);
            this.namePrefix(model.namePrefix);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPartnerEventSourcesRequest build() {
            return new ListPartnerEventSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnerEventSourcesRequest> {
        public Builder namePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

