/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetsByRuleRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, ListTargetsByRuleRequest> {
    private static final SdkField<String> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rule").getter(ListTargetsByRuleRequest.getter(ListTargetsByRuleRequest::rule)).setter(ListTargetsByRuleRequest.setter(Builder::rule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusName").getter(ListTargetsByRuleRequest.getter(ListTargetsByRuleRequest::eventBusName)).setter(ListTargetsByRuleRequest.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTargetsByRuleRequest.getter(ListTargetsByRuleRequest::nextToken)).setter(ListTargetsByRuleRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListTargetsByRuleRequest.getter(ListTargetsByRuleRequest::limit)).setter(ListTargetsByRuleRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD, EVENT_BUS_NAME_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTargetsByRuleRequest.memberNameToFieldInitializer();
    private final String rule;
    private final String eventBusName;
    private final String nextToken;
    private final Integer limit;

    private ListTargetsByRuleRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.eventBusName = builder.eventBusName;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public final String rule() {
        return this.rule;
    }

    public final String eventBusName() {
        return this.eventBusName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsByRuleRequest)) {
            return false;
        }
        ListTargetsByRuleRequest other = (ListTargetsByRuleRequest)((Object)obj);
        return Objects.equals(this.rule(), other.rule()) && Objects.equals(this.eventBusName(), other.eventBusName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"ListTargetsByRuleRequest").add("Rule", (Object)this.rule()).add("EventBusName", (Object)this.eventBusName()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Rule", RULE_FIELD);
        map.put("EventBusName", EVENT_BUS_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTargetsByRuleRequest, T> g) {
        return obj -> g.apply((ListTargetsByRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String rule;
        private String eventBusName;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsByRuleRequest model) {
            super(model);
            this.rule(model.rule);
            this.eventBusName(model.eventBusName);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getRule() {
            return this.rule;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTargetsByRuleRequest build() {
            return new ListTargetsByRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTargetsByRuleRequest> {
        public Builder rule(String var1);

        public Builder eventBusName(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

