/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.AssociatedPackage;
import software.amazon.awssdk.services.codeartifact.model.ListAssociatedPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListAssociatedPackagesResponse;

public class ListAssociatedPackagesPublisher
implements SdkPublisher<ListAssociatedPackagesResponse> {
    private final CodeartifactAsyncClient client;
    private final ListAssociatedPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedPackagesPublisher(CodeartifactAsyncClient client, ListAssociatedPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedPackagesPublisher(CodeartifactAsyncClient client, ListAssociatedPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociatedPackage> packages() {
        Function<ListAssociatedPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packages() != null) {
                return response.packages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociatedPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssociatedPackagesResponseFetcher
    implements AsyncPageFetcher<ListAssociatedPackagesResponse> {
        private ListAssociatedPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedPackagesResponse> nextPage(ListAssociatedPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedPackagesPublisher.this.client.listAssociatedPackages(ListAssociatedPackagesPublisher.this.firstRequest);
            }
            return ListAssociatedPackagesPublisher.this.client.listAssociatedPackages((ListAssociatedPackagesRequest)((Object)ListAssociatedPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

