/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAllowedRepositoriesForGroupRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, ListAllowedRepositoriesForGroupRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::domain)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::domainOwner)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageGroup").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::packageGroup)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::packageGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package-group").build()}).build();
    private static final SdkField<String> ORIGIN_RESTRICTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originRestrictionType").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::originRestrictionTypeAsString)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::originRestrictionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("originRestrictionType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::maxResults)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAllowedRepositoriesForGroupRequest.getter(ListAllowedRepositoriesForGroupRequest::nextToken)).setter(ListAllowedRepositoriesForGroupRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, ORIGIN_RESTRICTION_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAllowedRepositoriesForGroupRequest.memberNameToFieldInitializer();
    private final String domain;
    private final String domainOwner;
    private final String packageGroup;
    private final String originRestrictionType;
    private final Integer maxResults;
    private final String nextToken;

    private ListAllowedRepositoriesForGroupRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.originRestrictionType = builder.originRestrictionType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String packageGroup() {
        return this.packageGroup;
    }

    public final PackageGroupOriginRestrictionType originRestrictionType() {
        return PackageGroupOriginRestrictionType.fromValue(this.originRestrictionType);
    }

    public final String originRestrictionTypeAsString() {
        return this.originRestrictionType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRestrictionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedRepositoriesForGroupRequest)) {
            return false;
        }
        ListAllowedRepositoriesForGroupRequest other = (ListAllowedRepositoriesForGroupRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.packageGroup(), other.packageGroup()) && Objects.equals(this.originRestrictionTypeAsString(), other.originRestrictionTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAllowedRepositoriesForGroupRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("PackageGroup", (Object)this.packageGroup()).add("OriginRestrictionType", (Object)this.originRestrictionTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "packageGroup": {
                return Optional.ofNullable(clazz.cast(this.packageGroup()));
            }
            case "originRestrictionType": {
                return Optional.ofNullable(clazz.cast(this.originRestrictionTypeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("domain-owner", DOMAIN_OWNER_FIELD);
        map.put("package-group", PACKAGE_GROUP_FIELD);
        map.put("originRestrictionType", ORIGIN_RESTRICTION_TYPE_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedRepositoriesForGroupRequest, T> g) {
        return obj -> g.apply((ListAllowedRepositoriesForGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String packageGroup;
        private String originRestrictionType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedRepositoriesForGroupRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.packageGroup(model.packageGroup);
            this.originRestrictionType(model.originRestrictionType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return this.packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final String getOriginRestrictionType() {
            return this.originRestrictionType;
        }

        public final void setOriginRestrictionType(String originRestrictionType) {
            this.originRestrictionType = originRestrictionType;
        }

        @Override
        public final Builder originRestrictionType(String originRestrictionType) {
            this.originRestrictionType = originRestrictionType;
            return this;
        }

        @Override
        public final Builder originRestrictionType(PackageGroupOriginRestrictionType originRestrictionType) {
            this.originRestrictionType(originRestrictionType == null ? null : originRestrictionType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAllowedRepositoriesForGroupRequest build() {
            return new ListAllowedRepositoriesForGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAllowedRepositoriesForGroupRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder packageGroup(String var1);

        public Builder originRestrictionType(String var1);

        public Builder originRestrictionType(PackageGroupOriginRestrictionType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

