/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesResponse;

public class ListSandboxesIterable
implements SdkIterable<ListSandboxesResponse> {
    private final CodeBuildClient client;
    private final ListSandboxesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSandboxesIterable(CodeBuildClient client, ListSandboxesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSandboxesResponseFetcher();
    }

    public Iterator<ListSandboxesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListSandboxesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSandboxesResponseFetcher
    implements SyncPageFetcher<ListSandboxesResponse> {
        private ListSandboxesResponseFetcher() {
        }

        public boolean hasNextPage(ListSandboxesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSandboxesResponse nextPage(ListSandboxesResponse previousPage) {
            if (previousPage == null) {
                return ListSandboxesIterable.this.client.listSandboxes(ListSandboxesIterable.this.firstRequest);
            }
            return ListSandboxesIterable.this.client.listSandboxes((ListSandboxesRequest)((Object)ListSandboxesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

