/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowRunMode {
    QUEUED("QUEUED"),
    PARALLEL("PARALLEL"),
    SUPERSEDED("SUPERSEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowRunMode> VALUE_MAP;
    private final String value;

    private WorkflowRunMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowRunMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowRunMode> knownValues() {
        EnumSet<WorkflowRunMode> knownValues = EnumSet.allOf(WorkflowRunMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowRunMode.class, WorkflowRunMode::toString);
    }
}

