/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowRunStatus {
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    STOPPED("STOPPED"),
    SUPERSEDED("SUPERSEDED"),
    CANCELLED("CANCELLED"),
    NOT_RUN("NOT_RUN"),
    VALIDATING("VALIDATING"),
    PROVISIONING("PROVISIONING"),
    IN_PROGRESS("IN_PROGRESS"),
    STOPPING("STOPPING"),
    ABANDONED("ABANDONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowRunStatus> VALUE_MAP;
    private final String value;

    private WorkflowRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowRunStatus> knownValues() {
        EnumSet<WorkflowRunStatus> knownValues = EnumSet.allOf(WorkflowRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowRunStatus.class, WorkflowRunStatus::toString);
    }
}

