/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a change in the approval state for a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalStateChangedEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalStateChangedEventMetadata.Builder, ApprovalStateChangedEventMetadata> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ApprovalStateChangedEventMetadata::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalStatus").getter(getter(ApprovalStateChangedEventMetadata::approvalStatusAsString))
            .setter(setter(Builder::approvalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD,
            APPROVAL_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String revisionId;

    private final String approvalStatus;

    private ApprovalStateChangedEventMetadata(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.approvalStatus = builder.approvalStatus;
    }

    /**
     * <p>
     * The revision ID of the pull request when the approval state changed.
     * </p>
     * 
     * @return The revision ID of the pull request when the approval state changed.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The approval status for the pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalStatus}
     * will return {@link ApprovalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalStatusAsString}.
     * </p>
     * 
     * @return The approval status for the pull request.
     * @see ApprovalState
     */
    public final ApprovalState approvalStatus() {
        return ApprovalState.fromValue(approvalStatus);
    }

    /**
     * <p>
     * The approval status for the pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalStatus}
     * will return {@link ApprovalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalStatusAsString}.
     * </p>
     * 
     * @return The approval status for the pull request.
     * @see ApprovalState
     */
    public final String approvalStatusAsString() {
        return approvalStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalStateChangedEventMetadata)) {
            return false;
        }
        ApprovalStateChangedEventMetadata other = (ApprovalStateChangedEventMetadata) obj;
        return Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(approvalStatusAsString(), other.approvalStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApprovalStateChangedEventMetadata").add("RevisionId", revisionId())
                .add("ApprovalStatus", approvalStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "approvalStatus":
            return Optional.ofNullable(clazz.cast(approvalStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalStateChangedEventMetadata, T> g) {
        return obj -> g.apply((ApprovalStateChangedEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalStateChangedEventMetadata> {
        /**
         * <p>
         * The revision ID of the pull request when the approval state changed.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the pull request when the approval state changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The approval status for the pull request.
         * </p>
         * 
         * @param approvalStatus
         *        The approval status for the pull request.
         * @see ApprovalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalState
         */
        Builder approvalStatus(String approvalStatus);

        /**
         * <p>
         * The approval status for the pull request.
         * </p>
         * 
         * @param approvalStatus
         *        The approval status for the pull request.
         * @see ApprovalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalState
         */
        Builder approvalStatus(ApprovalState approvalStatus);
    }

    static final class BuilderImpl implements Builder {
        private String revisionId;

        private String approvalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalStateChangedEventMetadata model) {
            revisionId(model.revisionId);
            approvalStatus(model.approvalStatus);
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getApprovalStatus() {
            return approvalStatus;
        }

        public final void setApprovalStatus(String approvalStatus) {
            this.approvalStatus = approvalStatus;
        }

        @Override
        @Transient
        public final Builder approvalStatus(String approvalStatus) {
            this.approvalStatus = approvalStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder approvalStatus(ApprovalState approvalStatus) {
            this.approvalStatus(approvalStatus == null ? null : approvalStatus.toString());
            return this;
        }

        @Override
        public ApprovalStateChangedEventMetadata build() {
            return new ApprovalStateChangedEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
