/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the type of an object in a merge operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectTypes implements SdkPojo, Serializable, ToCopyableBuilder<ObjectTypes.Builder, ObjectTypes> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ObjectTypes::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(ObjectTypes::destinationAsString)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("base")
            .getter(getter(ObjectTypes::baseAsString)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String destination;

    private final String base;

    private ObjectTypes(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    /**
     * <p>
     * The type of the object in the source branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The type of the object in the source branch.
     * @see ObjectTypeEnum
     */
    public final ObjectTypeEnum source() {
        return ObjectTypeEnum.fromValue(source);
    }

    /**
     * <p>
     * The type of the object in the source branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The type of the object in the source branch.
     * @see ObjectTypeEnum
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The type of the object in the destination branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The type of the object in the destination branch.
     * @see ObjectTypeEnum
     */
    public final ObjectTypeEnum destination() {
        return ObjectTypeEnum.fromValue(destination);
    }

    /**
     * <p>
     * The type of the object in the destination branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The type of the object in the destination branch.
     * @see ObjectTypeEnum
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * The type of the object in the base commit of the merge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #base} will return
     * {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseAsString}.
     * </p>
     * 
     * @return The type of the object in the base commit of the merge.
     * @see ObjectTypeEnum
     */
    public final ObjectTypeEnum base() {
        return ObjectTypeEnum.fromValue(base);
    }

    /**
     * <p>
     * The type of the object in the base commit of the merge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #base} will return
     * {@link ObjectTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseAsString}.
     * </p>
     * 
     * @return The type of the object in the base commit of the merge.
     * @see ObjectTypeEnum
     */
    public final String baseAsString() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypes)) {
            return false;
        }
        ObjectTypes other = (ObjectTypes) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(baseAsString(), other.baseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectTypes").add("Source", sourceAsString()).add("Destination", destinationAsString())
                .add("Base", baseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "base":
            return Optional.ofNullable(clazz.cast(baseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectTypes, T> g) {
        return obj -> g.apply((ObjectTypes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectTypes> {
        /**
         * <p>
         * The type of the object in the source branch.
         * </p>
         * 
         * @param source
         *        The type of the object in the source branch.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder source(String source);

        /**
         * <p>
         * The type of the object in the source branch.
         * </p>
         * 
         * @param source
         *        The type of the object in the source branch.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder source(ObjectTypeEnum source);

        /**
         * <p>
         * The type of the object in the destination branch.
         * </p>
         * 
         * @param destination
         *        The type of the object in the destination branch.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder destination(String destination);

        /**
         * <p>
         * The type of the object in the destination branch.
         * </p>
         * 
         * @param destination
         *        The type of the object in the destination branch.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder destination(ObjectTypeEnum destination);

        /**
         * <p>
         * The type of the object in the base commit of the merge.
         * </p>
         * 
         * @param base
         *        The type of the object in the base commit of the merge.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder base(String base);

        /**
         * <p>
         * The type of the object in the base commit of the merge.
         * </p>
         * 
         * @param base
         *        The type of the object in the base commit of the merge.
         * @see ObjectTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectTypeEnum
         */
        Builder base(ObjectTypeEnum base);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String destination;

        private String base;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectTypes model) {
            source(model.source);
            destination(model.destination);
            base(model.base);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        @Transient
        public final Builder source(ObjectTypeEnum source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        @Transient
        public final Builder destination(ObjectTypeEnum destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getBase() {
            return base;
        }

        public final void setBase(String base) {
            this.base = base;
        }

        @Override
        @Transient
        public final Builder base(String base) {
            this.base = base;
            return this;
        }

        @Override
        @Transient
        public final Builder base(ObjectTypeEnum base) {
            this.base(base == null ? null : base.toString());
            return this;
        }

        @Override
        public ObjectTypes build() {
            return new ObjectTypes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
