/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a replacement content entry in the conflict of a merge or pull request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceContentEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplaceContentEntry.Builder, ReplaceContentEntry> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(ReplaceContentEntry::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> REPLACEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replacementType").getter(getter(ReplaceContentEntry::replacementTypeAsString))
            .setter(setter(Builder::replacementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacementType").build()).build();

    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("content").getter(getter(ReplaceContentEntry::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileMode").getter(getter(ReplaceContentEntry::fileModeAsString)).setter(setter(Builder::fileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            REPLACEMENT_TYPE_FIELD, CONTENT_FIELD, FILE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String replacementType;

    private final SdkBytes content;

    private final String fileMode;

    private ReplaceContentEntry(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.replacementType = builder.replacementType;
        this.content = builder.content;
        this.fileMode = builder.fileMode;
    }

    /**
     * <p>
     * The path of the conflicting file.
     * </p>
     * 
     * @return The path of the conflicting file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The replacement type to use when determining how to resolve the conflict.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacementType}
     * will return {@link ReplacementTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replacementTypeAsString}.
     * </p>
     * 
     * @return The replacement type to use when determining how to resolve the conflict.
     * @see ReplacementTypeEnum
     */
    public final ReplacementTypeEnum replacementType() {
        return ReplacementTypeEnum.fromValue(replacementType);
    }

    /**
     * <p>
     * The replacement type to use when determining how to resolve the conflict.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacementType}
     * will return {@link ReplacementTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replacementTypeAsString}.
     * </p>
     * 
     * @return The replacement type to use when determining how to resolve the conflict.
     * @see ReplacementTypeEnum
     */
    public final String replacementTypeAsString() {
        return replacementType;
    }

    /**
     * <p>
     * The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
     * </p>
     * 
     * @return The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
     */
    public final SdkBytes content() {
        return content;
    }

    /**
     * <p>
     * The file mode to apply during conflict resoltion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The file mode to apply during conflict resoltion.
     * @see FileModeTypeEnum
     */
    public final FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(fileMode);
    }

    /**
     * <p>
     * The file mode to apply during conflict resoltion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The file mode to apply during conflict resoltion.
     * @see FileModeTypeEnum
     */
    public final String fileModeAsString() {
        return fileMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(replacementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(fileModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceContentEntry)) {
            return false;
        }
        ReplaceContentEntry other = (ReplaceContentEntry) obj;
        return Objects.equals(filePath(), other.filePath())
                && Objects.equals(replacementTypeAsString(), other.replacementTypeAsString())
                && Objects.equals(content(), other.content()) && Objects.equals(fileModeAsString(), other.fileModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceContentEntry").add("FilePath", filePath())
                .add("ReplacementType", replacementTypeAsString()).add("Content", content()).add("FileMode", fileModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "replacementType":
            return Optional.ofNullable(clazz.cast(replacementTypeAsString()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "fileMode":
            return Optional.ofNullable(clazz.cast(fileModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceContentEntry, T> g) {
        return obj -> g.apply((ReplaceContentEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplaceContentEntry> {
        /**
         * <p>
         * The path of the conflicting file.
         * </p>
         * 
         * @param filePath
         *        The path of the conflicting file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The replacement type to use when determining how to resolve the conflict.
         * </p>
         * 
         * @param replacementType
         *        The replacement type to use when determining how to resolve the conflict.
         * @see ReplacementTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacementTypeEnum
         */
        Builder replacementType(String replacementType);

        /**
         * <p>
         * The replacement type to use when determining how to resolve the conflict.
         * </p>
         * 
         * @param replacementType
         *        The replacement type to use when determining how to resolve the conflict.
         * @see ReplacementTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplacementTypeEnum
         */
        Builder replacementType(ReplacementTypeEnum replacementType);

        /**
         * <p>
         * The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
         * </p>
         * 
         * @param content
         *        The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SdkBytes content);

        /**
         * <p>
         * The file mode to apply during conflict resoltion.
         * </p>
         * 
         * @param fileMode
         *        The file mode to apply during conflict resoltion.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(String fileMode);

        /**
         * <p>
         * The file mode to apply during conflict resoltion.
         * </p>
         * 
         * @param fileMode
         *        The file mode to apply during conflict resoltion.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(FileModeTypeEnum fileMode);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String replacementType;

        private SdkBytes content;

        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceContentEntry model) {
            filePath(model.filePath);
            replacementType(model.replacementType);
            content(model.content);
            fileMode(model.fileMode);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        @Transient
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getReplacementType() {
            return replacementType;
        }

        public final void setReplacementType(String replacementType) {
            this.replacementType = replacementType;
        }

        @Override
        @Transient
        public final Builder replacementType(String replacementType) {
            this.replacementType = replacementType;
            return this;
        }

        @Override
        @Transient
        public final Builder replacementType(ReplacementTypeEnum replacementType) {
            this.replacementType(replacementType == null ? null : replacementType.toString());
            return this;
        }

        public final ByteBuffer getContent() {
            return content == null ? null : content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            content(content == null ? null : SdkBytes.fromByteBuffer(content));
        }

        @Override
        @Transient
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getFileMode() {
            return fileMode;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        @Override
        @Transient
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        @Transient
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        @Override
        public ReplaceContentEntry build() {
            return new ReplaceContentEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
