/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeBranchesByFastForwardRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, MergeBranchesByFastForwardRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(MergeBranchesByFastForwardRequest.getter(MergeBranchesByFastForwardRequest::repositoryName)).setter(MergeBranchesByFastForwardRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitSpecifier").getter(MergeBranchesByFastForwardRequest.getter(MergeBranchesByFastForwardRequest::sourceCommitSpecifier)).setter(MergeBranchesByFastForwardRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitSpecifier").getter(MergeBranchesByFastForwardRequest.getter(MergeBranchesByFastForwardRequest::destinationCommitSpecifier)).setter(MergeBranchesByFastForwardRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> TARGET_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetBranch").getter(MergeBranchesByFastForwardRequest.getter(MergeBranchesByFastForwardRequest::targetBranch)).setter(MergeBranchesByFastForwardRequest.setter(Builder::targetBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBranch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, TARGET_BRANCH_FIELD));
    private final String repositoryName;
    private final String sourceCommitSpecifier;
    private final String destinationCommitSpecifier;
    private final String targetBranch;

    private MergeBranchesByFastForwardRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.targetBranch = builder.targetBranch;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public final String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public final String targetBranch() {
        return this.targetBranch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBranch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesByFastForwardRequest)) {
            return false;
        }
        MergeBranchesByFastForwardRequest other = (MergeBranchesByFastForwardRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.targetBranch(), other.targetBranch());
    }

    public final String toString() {
        return ToString.builder((String)"MergeBranchesByFastForwardRequest").add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("TargetBranch", (Object)this.targetBranch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "targetBranch": {
                return Optional.ofNullable(clazz.cast(this.targetBranch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesByFastForwardRequest, T> g) {
        return obj -> g.apply((MergeBranchesByFastForwardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceCommitSpecifier;
        private String destinationCommitSpecifier;
        private String targetBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesByFastForwardRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.targetBranch(model.targetBranch);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        @Override
        @Transient
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        @Override
        @Transient
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final String getTargetBranch() {
            return this.targetBranch;
        }

        public final void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        @Override
        @Transient
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeBranchesByFastForwardRequest build() {
            return new MergeBranchesByFastForwardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeBranchesByFastForwardRequest> {
        public Builder repositoryName(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder targetBranch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

