/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(Target.getter(Target::repositoryName)).setter(Target.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceReference").getter(Target.getter(Target::sourceReference)).setter(Target.setter(Builder::sourceReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()}).build();
    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationReference").getter(Target.getter(Target::destinationReference)).setter(Target.setter(Builder::destinationReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_REFERENCE_FIELD, DESTINATION_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Target.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String sourceReference;
    private final String destinationReference;

    private Target(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceReference = builder.sourceReference;
        this.destinationReference = builder.destinationReference;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String sourceReference() {
        return this.sourceReference;
    }

    public final String destinationReference() {
        return this.destinationReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceReference(), other.sourceReference()) && Objects.equals(this.destinationReference(), other.destinationReference());
    }

    public final String toString() {
        return ToString.builder((String)"Target").add("RepositoryName", (Object)this.repositoryName()).add("SourceReference", (Object)this.sourceReference()).add("DestinationReference", (Object)this.destinationReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceReference": {
                return Optional.ofNullable(clazz.cast(this.sourceReference()));
            }
            case "destinationReference": {
                return Optional.ofNullable(clazz.cast(this.destinationReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("sourceReference", SOURCE_REFERENCE_FIELD);
        map.put("destinationReference", DESTINATION_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceReference;
        private String destinationReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.repositoryName(model.repositoryName);
            this.sourceReference(model.sourceReference);
            this.destinationReference(model.destinationReference);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceReference() {
            return this.sourceReference;
        }

        public final void setSourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
        }

        @Override
        public final Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final String getDestinationReference() {
            return this.destinationReference;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder repositoryName(String var1);

        public Builder sourceReference(String var1);

        public Builder destinationReference(String var1);
    }
}

