/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ConflictResolution;
import software.amazon.awssdk.services.codecommit.model.ConflictResolutionStrategyTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeBranchesBySquashRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, MergeBranchesBySquashRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::repositoryName)).setter(MergeBranchesBySquashRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitSpecifier").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::sourceCommitSpecifier)).setter(MergeBranchesBySquashRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitSpecifier").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::destinationCommitSpecifier)).setter(MergeBranchesBySquashRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> TARGET_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetBranch").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::targetBranch)).setter(MergeBranchesBySquashRequest.setter(Builder::targetBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBranch").build()}).build();
    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictDetailLevel").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::conflictDetailLevelAsString)).setter(MergeBranchesBySquashRequest.setter(Builder::conflictDetailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build()}).build();
    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictResolutionStrategy").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::conflictResolutionStrategyAsString)).setter(MergeBranchesBySquashRequest.setter(Builder::conflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build()}).build();
    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorName").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::authorName)).setter(MergeBranchesBySquashRequest.setter(Builder::authorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::email)).setter(MergeBranchesBySquashRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitMessage").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::commitMessage)).setter(MergeBranchesBySquashRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("keepEmptyFolders").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::keepEmptyFolders)).setter(MergeBranchesBySquashRequest.setter(Builder::keepEmptyFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()}).build();
    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conflictResolution").getter(MergeBranchesBySquashRequest.getter(MergeBranchesBySquashRequest::conflictResolution)).setter(MergeBranchesBySquashRequest.setter(Builder::conflictResolution)).constructor(ConflictResolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, TARGET_BRANCH_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD, AUTHOR_NAME_FIELD, EMAIL_FIELD, COMMIT_MESSAGE_FIELD, KEEP_EMPTY_FOLDERS_FIELD, CONFLICT_RESOLUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MergeBranchesBySquashRequest.memberNameToFieldInitializer();
    private final String repositoryName;
    private final String sourceCommitSpecifier;
    private final String destinationCommitSpecifier;
    private final String targetBranch;
    private final String conflictDetailLevel;
    private final String conflictResolutionStrategy;
    private final String authorName;
    private final String email;
    private final String commitMessage;
    private final Boolean keepEmptyFolders;
    private final ConflictResolution conflictResolution;

    private MergeBranchesBySquashRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.targetBranch = builder.targetBranch;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.authorName = builder.authorName;
        this.email = builder.email;
        this.commitMessage = builder.commitMessage;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.conflictResolution = builder.conflictResolution;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public final String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public final String targetBranch() {
        return this.targetBranch;
    }

    public final ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(this.conflictDetailLevel);
    }

    public final String conflictDetailLevelAsString() {
        return this.conflictDetailLevel;
    }

    public final ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(this.conflictResolutionStrategy);
    }

    public final String conflictResolutionStrategyAsString() {
        return this.conflictResolutionStrategy;
    }

    public final String authorName() {
        return this.authorName;
    }

    public final String email() {
        return this.email;
    }

    public final String commitMessage() {
        return this.commitMessage;
    }

    public final Boolean keepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public final ConflictResolution conflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesBySquashRequest)) {
            return false;
        }
        MergeBranchesBySquashRequest other = (MergeBranchesBySquashRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.targetBranch(), other.targetBranch()) && Objects.equals(this.conflictDetailLevelAsString(), other.conflictDetailLevelAsString()) && Objects.equals(this.conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString()) && Objects.equals(this.authorName(), other.authorName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.keepEmptyFolders(), other.keepEmptyFolders()) && Objects.equals(this.conflictResolution(), other.conflictResolution());
    }

    public final String toString() {
        return ToString.builder((String)"MergeBranchesBySquashRequest").add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("TargetBranch", (Object)this.targetBranch()).add("ConflictDetailLevel", (Object)this.conflictDetailLevelAsString()).add("ConflictResolutionStrategy", (Object)this.conflictResolutionStrategyAsString()).add("AuthorName", (Object)this.authorName()).add("Email", (Object)this.email()).add("CommitMessage", (Object)this.commitMessage()).add("KeepEmptyFolders", (Object)this.keepEmptyFolders()).add("ConflictResolution", (Object)this.conflictResolution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "targetBranch": {
                return Optional.ofNullable(clazz.cast(this.targetBranch()));
            }
            case "conflictDetailLevel": {
                return Optional.ofNullable(clazz.cast(this.conflictDetailLevelAsString()));
            }
            case "conflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.conflictResolutionStrategyAsString()));
            }
            case "authorName": {
                return Optional.ofNullable(clazz.cast(this.authorName()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "keepEmptyFolders": {
                return Optional.ofNullable(clazz.cast(this.keepEmptyFolders()));
            }
            case "conflictResolution": {
                return Optional.ofNullable(clazz.cast(this.conflictResolution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("sourceCommitSpecifier", SOURCE_COMMIT_SPECIFIER_FIELD);
        map.put("destinationCommitSpecifier", DESTINATION_COMMIT_SPECIFIER_FIELD);
        map.put("targetBranch", TARGET_BRANCH_FIELD);
        map.put("conflictDetailLevel", CONFLICT_DETAIL_LEVEL_FIELD);
        map.put("conflictResolutionStrategy", CONFLICT_RESOLUTION_STRATEGY_FIELD);
        map.put("authorName", AUTHOR_NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("commitMessage", COMMIT_MESSAGE_FIELD);
        map.put("keepEmptyFolders", KEEP_EMPTY_FOLDERS_FIELD);
        map.put("conflictResolution", CONFLICT_RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesBySquashRequest, T> g) {
        return obj -> g.apply((MergeBranchesBySquashRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceCommitSpecifier;
        private String destinationCommitSpecifier;
        private String targetBranch;
        private String conflictDetailLevel;
        private String conflictResolutionStrategy;
        private String authorName;
        private String email;
        private String commitMessage;
        private Boolean keepEmptyFolders;
        private ConflictResolution conflictResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesBySquashRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.targetBranch(model.targetBranch);
            this.conflictDetailLevel(model.conflictDetailLevel);
            this.conflictResolutionStrategy(model.conflictResolutionStrategy);
            this.authorName(model.authorName);
            this.email(model.email);
            this.commitMessage(model.commitMessage);
            this.keepEmptyFolders(model.keepEmptyFolders);
            this.conflictResolution(model.conflictResolution);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final String getTargetBranch() {
            return this.targetBranch;
        }

        public final void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        @Override
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        public final String getConflictDetailLevel() {
            return this.conflictDetailLevel;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final String getConflictResolutionStrategy() {
            return this.conflictResolutionStrategy;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final String getAuthorName() {
            return this.authorName;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        @Override
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final Boolean getKeepEmptyFolders() {
            return this.keepEmptyFolders;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return this.conflictResolution != null ? this.conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeBranchesBySquashRequest build() {
            return new MergeBranchesBySquashRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeBranchesBySquashRequest> {
        public Builder repositoryName(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder targetBranch(String var1);

        public Builder conflictDetailLevel(String var1);

        public Builder conflictDetailLevel(ConflictDetailLevelTypeEnum var1);

        public Builder conflictResolutionStrategy(String var1);

        public Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum var1);

        public Builder authorName(String var1);

        public Builder email(String var1);

        public Builder commitMessage(String var1);

        public Builder keepEmptyFolders(Boolean var1);

        public Builder conflictResolution(ConflictResolution var1);

        default public Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return this.conflictResolution((ConflictResolution)((ConflictResolution.Builder)ConflictResolution.builder().applyMutation(conflictResolution)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

