/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostCommentReplyRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, PostCommentReplyRequest> {
    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inReplyTo").getter(PostCommentReplyRequest.getter(PostCommentReplyRequest::inReplyTo)).setter(PostCommentReplyRequest.setter(Builder::inReplyTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inReplyTo").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(PostCommentReplyRequest.getter(PostCommentReplyRequest::clientRequestToken)).setter(PostCommentReplyRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(PostCommentReplyRequest.getter(PostCommentReplyRequest::content)).setter(PostCommentReplyRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IN_REPLY_TO_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PostCommentReplyRequest.memberNameToFieldInitializer();
    private final String inReplyTo;
    private final String clientRequestToken;
    private final String content;

    private PostCommentReplyRequest(BuilderImpl builder) {
        super(builder);
        this.inReplyTo = builder.inReplyTo;
        this.clientRequestToken = builder.clientRequestToken;
        this.content = builder.content;
    }

    public final String inReplyTo() {
        return this.inReplyTo;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String content() {
        return this.content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentReplyRequest)) {
            return false;
        }
        PostCommentReplyRequest other = (PostCommentReplyRequest)((Object)obj);
        return Objects.equals(this.inReplyTo(), other.inReplyTo()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"PostCommentReplyRequest").add("InReplyTo", (Object)this.inReplyTo()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inReplyTo": {
                return Optional.ofNullable(clazz.cast(this.inReplyTo()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("inReplyTo", IN_REPLY_TO_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostCommentReplyRequest, T> g) {
        return obj -> g.apply((PostCommentReplyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String inReplyTo;
        private String clientRequestToken;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentReplyRequest model) {
            super(model);
            this.inReplyTo(model.inReplyTo);
            this.clientRequestToken(model.clientRequestToken);
            this.content(model.content);
        }

        public final String getInReplyTo() {
            return this.inReplyTo;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostCommentReplyRequest build() {
            return new PostCommentReplyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostCommentReplyRequest> {
        public Builder inReplyTo(String var1);

        public Builder clientRequestToken(String var1);

        public Builder content(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

