/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata;
import software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestEventType;
import software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequestEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequestEvent> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestId)).setter(PullRequestEvent.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventDate").getter(PullRequestEvent.getter(PullRequestEvent::eventDate)).setter(PullRequestEvent.setter(Builder::eventDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDate").build()}).build();
    private static final SdkField<String> PULL_REQUEST_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestEventType").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestEventTypeAsString)).setter(PullRequestEvent.setter(Builder::pullRequestEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEventType").build()}).build();
    private static final SdkField<String> ACTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actorArn").getter(PullRequestEvent.getter(PullRequestEvent::actorArn)).setter(PullRequestEvent.setter(Builder::actorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorArn").build()}).build();
    private static final SdkField<PullRequestCreatedEventMetadata> PULL_REQUEST_CREATED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pullRequestCreatedEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestCreatedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestCreatedEventMetadata)).constructor(PullRequestCreatedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestCreatedEventMetadata").build()}).build();
    private static final SdkField<PullRequestStatusChangedEventMetadata> PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pullRequestStatusChangedEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestStatusChangedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestStatusChangedEventMetadata)).constructor(PullRequestStatusChangedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatusChangedEventMetadata").build()}).build();
    private static final SdkField<PullRequestSourceReferenceUpdatedEventMetadata> PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pullRequestSourceReferenceUpdatedEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestSourceReferenceUpdatedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestSourceReferenceUpdatedEventMetadata)).constructor(PullRequestSourceReferenceUpdatedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestSourceReferenceUpdatedEventMetadata").build()}).build();
    private static final SdkField<PullRequestMergedStateChangedEventMetadata> PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pullRequestMergedStateChangedEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::pullRequestMergedStateChangedEventMetadata)).setter(PullRequestEvent.setter(Builder::pullRequestMergedStateChangedEventMetadata)).constructor(PullRequestMergedStateChangedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestMergedStateChangedEventMetadata").build()}).build();
    private static final SdkField<ApprovalRuleEventMetadata> APPROVAL_RULE_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("approvalRuleEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::approvalRuleEventMetadata)).setter(PullRequestEvent.setter(Builder::approvalRuleEventMetadata)).constructor(ApprovalRuleEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleEventMetadata").build()}).build();
    private static final SdkField<ApprovalStateChangedEventMetadata> APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("approvalStateChangedEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::approvalStateChangedEventMetadata)).setter(PullRequestEvent.setter(Builder::approvalStateChangedEventMetadata)).constructor(ApprovalStateChangedEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalStateChangedEventMetadata").build()}).build();
    private static final SdkField<ApprovalRuleOverriddenEventMetadata> APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("approvalRuleOverriddenEventMetadata").getter(PullRequestEvent.getter(PullRequestEvent::approvalRuleOverriddenEventMetadata)).setter(PullRequestEvent.setter(Builder::approvalRuleOverriddenEventMetadata)).constructor(ApprovalRuleOverriddenEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleOverriddenEventMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, EVENT_DATE_FIELD, PULL_REQUEST_EVENT_TYPE_FIELD, ACTOR_ARN_FIELD, PULL_REQUEST_CREATED_EVENT_METADATA_FIELD, PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD, PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD, PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD, APPROVAL_RULE_EVENT_METADATA_FIELD, APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD, APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PullRequestEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pullRequestId;
    private final Instant eventDate;
    private final String pullRequestEventType;
    private final String actorArn;
    private final PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;
    private final PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;
    private final PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;
    private final PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;
    private final ApprovalRuleEventMetadata approvalRuleEventMetadata;
    private final ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata;
    private final ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata;

    private PullRequestEvent(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.eventDate = builder.eventDate;
        this.pullRequestEventType = builder.pullRequestEventType;
        this.actorArn = builder.actorArn;
        this.pullRequestCreatedEventMetadata = builder.pullRequestCreatedEventMetadata;
        this.pullRequestStatusChangedEventMetadata = builder.pullRequestStatusChangedEventMetadata;
        this.pullRequestSourceReferenceUpdatedEventMetadata = builder.pullRequestSourceReferenceUpdatedEventMetadata;
        this.pullRequestMergedStateChangedEventMetadata = builder.pullRequestMergedStateChangedEventMetadata;
        this.approvalRuleEventMetadata = builder.approvalRuleEventMetadata;
        this.approvalStateChangedEventMetadata = builder.approvalStateChangedEventMetadata;
        this.approvalRuleOverriddenEventMetadata = builder.approvalRuleOverriddenEventMetadata;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final Instant eventDate() {
        return this.eventDate;
    }

    public final PullRequestEventType pullRequestEventType() {
        return PullRequestEventType.fromValue(this.pullRequestEventType);
    }

    public final String pullRequestEventTypeAsString() {
        return this.pullRequestEventType;
    }

    public final String actorArn() {
        return this.actorArn;
    }

    public final PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata() {
        return this.pullRequestCreatedEventMetadata;
    }

    public final PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata() {
        return this.pullRequestStatusChangedEventMetadata;
    }

    public final PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata() {
        return this.pullRequestSourceReferenceUpdatedEventMetadata;
    }

    public final PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata() {
        return this.pullRequestMergedStateChangedEventMetadata;
    }

    public final ApprovalRuleEventMetadata approvalRuleEventMetadata() {
        return this.approvalRuleEventMetadata;
    }

    public final ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata() {
        return this.approvalStateChangedEventMetadata;
    }

    public final ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata() {
        return this.approvalRuleOverriddenEventMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestCreatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestSourceReferenceUpdatedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestMergedStateChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStateChangedEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleOverriddenEventMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestEvent)) {
            return false;
        }
        PullRequestEvent other = (PullRequestEvent)obj;
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.eventDate(), other.eventDate()) && Objects.equals(this.pullRequestEventTypeAsString(), other.pullRequestEventTypeAsString()) && Objects.equals(this.actorArn(), other.actorArn()) && Objects.equals(this.pullRequestCreatedEventMetadata(), other.pullRequestCreatedEventMetadata()) && Objects.equals(this.pullRequestStatusChangedEventMetadata(), other.pullRequestStatusChangedEventMetadata()) && Objects.equals(this.pullRequestSourceReferenceUpdatedEventMetadata(), other.pullRequestSourceReferenceUpdatedEventMetadata()) && Objects.equals(this.pullRequestMergedStateChangedEventMetadata(), other.pullRequestMergedStateChangedEventMetadata()) && Objects.equals(this.approvalRuleEventMetadata(), other.approvalRuleEventMetadata()) && Objects.equals(this.approvalStateChangedEventMetadata(), other.approvalStateChangedEventMetadata()) && Objects.equals(this.approvalRuleOverriddenEventMetadata(), other.approvalRuleOverriddenEventMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"PullRequestEvent").add("PullRequestId", (Object)this.pullRequestId()).add("EventDate", (Object)this.eventDate()).add("PullRequestEventType", (Object)this.pullRequestEventTypeAsString()).add("ActorArn", (Object)this.actorArn()).add("PullRequestCreatedEventMetadata", (Object)this.pullRequestCreatedEventMetadata()).add("PullRequestStatusChangedEventMetadata", (Object)this.pullRequestStatusChangedEventMetadata()).add("PullRequestSourceReferenceUpdatedEventMetadata", (Object)this.pullRequestSourceReferenceUpdatedEventMetadata()).add("PullRequestMergedStateChangedEventMetadata", (Object)this.pullRequestMergedStateChangedEventMetadata()).add("ApprovalRuleEventMetadata", (Object)this.approvalRuleEventMetadata()).add("ApprovalStateChangedEventMetadata", (Object)this.approvalStateChangedEventMetadata()).add("ApprovalRuleOverriddenEventMetadata", (Object)this.approvalRuleOverriddenEventMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "eventDate": {
                return Optional.ofNullable(clazz.cast(this.eventDate()));
            }
            case "pullRequestEventType": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEventTypeAsString()));
            }
            case "actorArn": {
                return Optional.ofNullable(clazz.cast(this.actorArn()));
            }
            case "pullRequestCreatedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestCreatedEventMetadata()));
            }
            case "pullRequestStatusChangedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusChangedEventMetadata()));
            }
            case "pullRequestSourceReferenceUpdatedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestSourceReferenceUpdatedEventMetadata()));
            }
            case "pullRequestMergedStateChangedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.pullRequestMergedStateChangedEventMetadata()));
            }
            case "approvalRuleEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleEventMetadata()));
            }
            case "approvalStateChangedEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.approvalStateChangedEventMetadata()));
            }
            case "approvalRuleOverriddenEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleOverriddenEventMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("eventDate", EVENT_DATE_FIELD);
        map.put("pullRequestEventType", PULL_REQUEST_EVENT_TYPE_FIELD);
        map.put("actorArn", ACTOR_ARN_FIELD);
        map.put("pullRequestCreatedEventMetadata", PULL_REQUEST_CREATED_EVENT_METADATA_FIELD);
        map.put("pullRequestStatusChangedEventMetadata", PULL_REQUEST_STATUS_CHANGED_EVENT_METADATA_FIELD);
        map.put("pullRequestSourceReferenceUpdatedEventMetadata", PULL_REQUEST_SOURCE_REFERENCE_UPDATED_EVENT_METADATA_FIELD);
        map.put("pullRequestMergedStateChangedEventMetadata", PULL_REQUEST_MERGED_STATE_CHANGED_EVENT_METADATA_FIELD);
        map.put("approvalRuleEventMetadata", APPROVAL_RULE_EVENT_METADATA_FIELD);
        map.put("approvalStateChangedEventMetadata", APPROVAL_STATE_CHANGED_EVENT_METADATA_FIELD);
        map.put("approvalRuleOverriddenEventMetadata", APPROVAL_RULE_OVERRIDDEN_EVENT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PullRequestEvent, T> g) {
        return obj -> g.apply((PullRequestEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pullRequestId;
        private Instant eventDate;
        private String pullRequestEventType;
        private String actorArn;
        private PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata;
        private PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata;
        private PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata;
        private PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata;
        private ApprovalRuleEventMetadata approvalRuleEventMetadata;
        private ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata;
        private ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestEvent model) {
            this.pullRequestId(model.pullRequestId);
            this.eventDate(model.eventDate);
            this.pullRequestEventType(model.pullRequestEventType);
            this.actorArn(model.actorArn);
            this.pullRequestCreatedEventMetadata(model.pullRequestCreatedEventMetadata);
            this.pullRequestStatusChangedEventMetadata(model.pullRequestStatusChangedEventMetadata);
            this.pullRequestSourceReferenceUpdatedEventMetadata(model.pullRequestSourceReferenceUpdatedEventMetadata);
            this.pullRequestMergedStateChangedEventMetadata(model.pullRequestMergedStateChangedEventMetadata);
            this.approvalRuleEventMetadata(model.approvalRuleEventMetadata);
            this.approvalStateChangedEventMetadata(model.approvalStateChangedEventMetadata);
            this.approvalRuleOverriddenEventMetadata(model.approvalRuleOverriddenEventMetadata);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final Instant getEventDate() {
            return this.eventDate;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final String getPullRequestEventType() {
            return this.pullRequestEventType;
        }

        public final void setPullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
        }

        @Override
        public final Builder pullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
            return this;
        }

        @Override
        public final Builder pullRequestEventType(PullRequestEventType pullRequestEventType) {
            this.pullRequestEventType(pullRequestEventType == null ? null : pullRequestEventType.toString());
            return this;
        }

        public final String getActorArn() {
            return this.actorArn;
        }

        public final void setActorArn(String actorArn) {
            this.actorArn = actorArn;
        }

        @Override
        public final Builder actorArn(String actorArn) {
            this.actorArn = actorArn;
            return this;
        }

        public final PullRequestCreatedEventMetadata.Builder getPullRequestCreatedEventMetadata() {
            return this.pullRequestCreatedEventMetadata != null ? this.pullRequestCreatedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata.BuilderImpl pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata != null ? pullRequestCreatedEventMetadata.build() : null;
        }

        @Override
        public final Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata pullRequestCreatedEventMetadata) {
            this.pullRequestCreatedEventMetadata = pullRequestCreatedEventMetadata;
            return this;
        }

        public final PullRequestStatusChangedEventMetadata.Builder getPullRequestStatusChangedEventMetadata() {
            return this.pullRequestStatusChangedEventMetadata != null ? this.pullRequestStatusChangedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata.BuilderImpl pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata != null ? pullRequestStatusChangedEventMetadata.build() : null;
        }

        @Override
        public final Builder pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata pullRequestStatusChangedEventMetadata) {
            this.pullRequestStatusChangedEventMetadata = pullRequestStatusChangedEventMetadata;
            return this;
        }

        public final PullRequestSourceReferenceUpdatedEventMetadata.Builder getPullRequestSourceReferenceUpdatedEventMetadata() {
            return this.pullRequestSourceReferenceUpdatedEventMetadata != null ? this.pullRequestSourceReferenceUpdatedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata.BuilderImpl pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata != null ? pullRequestSourceReferenceUpdatedEventMetadata.build() : null;
        }

        @Override
        public final Builder pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata pullRequestSourceReferenceUpdatedEventMetadata) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = pullRequestSourceReferenceUpdatedEventMetadata;
            return this;
        }

        public final PullRequestMergedStateChangedEventMetadata.Builder getPullRequestMergedStateChangedEventMetadata() {
            return this.pullRequestMergedStateChangedEventMetadata != null ? this.pullRequestMergedStateChangedEventMetadata.toBuilder() : null;
        }

        public final void setPullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata.BuilderImpl pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata != null ? pullRequestMergedStateChangedEventMetadata.build() : null;
        }

        @Override
        public final Builder pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata pullRequestMergedStateChangedEventMetadata) {
            this.pullRequestMergedStateChangedEventMetadata = pullRequestMergedStateChangedEventMetadata;
            return this;
        }

        public final ApprovalRuleEventMetadata.Builder getApprovalRuleEventMetadata() {
            return this.approvalRuleEventMetadata != null ? this.approvalRuleEventMetadata.toBuilder() : null;
        }

        public final void setApprovalRuleEventMetadata(ApprovalRuleEventMetadata.BuilderImpl approvalRuleEventMetadata) {
            this.approvalRuleEventMetadata = approvalRuleEventMetadata != null ? approvalRuleEventMetadata.build() : null;
        }

        @Override
        public final Builder approvalRuleEventMetadata(ApprovalRuleEventMetadata approvalRuleEventMetadata) {
            this.approvalRuleEventMetadata = approvalRuleEventMetadata;
            return this;
        }

        public final ApprovalStateChangedEventMetadata.Builder getApprovalStateChangedEventMetadata() {
            return this.approvalStateChangedEventMetadata != null ? this.approvalStateChangedEventMetadata.toBuilder() : null;
        }

        public final void setApprovalStateChangedEventMetadata(ApprovalStateChangedEventMetadata.BuilderImpl approvalStateChangedEventMetadata) {
            this.approvalStateChangedEventMetadata = approvalStateChangedEventMetadata != null ? approvalStateChangedEventMetadata.build() : null;
        }

        @Override
        public final Builder approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata approvalStateChangedEventMetadata) {
            this.approvalStateChangedEventMetadata = approvalStateChangedEventMetadata;
            return this;
        }

        public final ApprovalRuleOverriddenEventMetadata.Builder getApprovalRuleOverriddenEventMetadata() {
            return this.approvalRuleOverriddenEventMetadata != null ? this.approvalRuleOverriddenEventMetadata.toBuilder() : null;
        }

        public final void setApprovalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata.BuilderImpl approvalRuleOverriddenEventMetadata) {
            this.approvalRuleOverriddenEventMetadata = approvalRuleOverriddenEventMetadata != null ? approvalRuleOverriddenEventMetadata.build() : null;
        }

        @Override
        public final Builder approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata approvalRuleOverriddenEventMetadata) {
            this.approvalRuleOverriddenEventMetadata = approvalRuleOverriddenEventMetadata;
            return this;
        }

        public PullRequestEvent build() {
            return new PullRequestEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequestEvent> {
        public Builder pullRequestId(String var1);

        public Builder eventDate(Instant var1);

        public Builder pullRequestEventType(String var1);

        public Builder pullRequestEventType(PullRequestEventType var1);

        public Builder actorArn(String var1);

        public Builder pullRequestCreatedEventMetadata(PullRequestCreatedEventMetadata var1);

        default public Builder pullRequestCreatedEventMetadata(Consumer<PullRequestCreatedEventMetadata.Builder> pullRequestCreatedEventMetadata) {
            return this.pullRequestCreatedEventMetadata((PullRequestCreatedEventMetadata)((PullRequestCreatedEventMetadata.Builder)PullRequestCreatedEventMetadata.builder().applyMutation(pullRequestCreatedEventMetadata)).build());
        }

        public Builder pullRequestStatusChangedEventMetadata(PullRequestStatusChangedEventMetadata var1);

        default public Builder pullRequestStatusChangedEventMetadata(Consumer<PullRequestStatusChangedEventMetadata.Builder> pullRequestStatusChangedEventMetadata) {
            return this.pullRequestStatusChangedEventMetadata((PullRequestStatusChangedEventMetadata)((PullRequestStatusChangedEventMetadata.Builder)PullRequestStatusChangedEventMetadata.builder().applyMutation(pullRequestStatusChangedEventMetadata)).build());
        }

        public Builder pullRequestSourceReferenceUpdatedEventMetadata(PullRequestSourceReferenceUpdatedEventMetadata var1);

        default public Builder pullRequestSourceReferenceUpdatedEventMetadata(Consumer<PullRequestSourceReferenceUpdatedEventMetadata.Builder> pullRequestSourceReferenceUpdatedEventMetadata) {
            return this.pullRequestSourceReferenceUpdatedEventMetadata((PullRequestSourceReferenceUpdatedEventMetadata)((PullRequestSourceReferenceUpdatedEventMetadata.Builder)PullRequestSourceReferenceUpdatedEventMetadata.builder().applyMutation(pullRequestSourceReferenceUpdatedEventMetadata)).build());
        }

        public Builder pullRequestMergedStateChangedEventMetadata(PullRequestMergedStateChangedEventMetadata var1);

        default public Builder pullRequestMergedStateChangedEventMetadata(Consumer<PullRequestMergedStateChangedEventMetadata.Builder> pullRequestMergedStateChangedEventMetadata) {
            return this.pullRequestMergedStateChangedEventMetadata((PullRequestMergedStateChangedEventMetadata)((PullRequestMergedStateChangedEventMetadata.Builder)PullRequestMergedStateChangedEventMetadata.builder().applyMutation(pullRequestMergedStateChangedEventMetadata)).build());
        }

        public Builder approvalRuleEventMetadata(ApprovalRuleEventMetadata var1);

        default public Builder approvalRuleEventMetadata(Consumer<ApprovalRuleEventMetadata.Builder> approvalRuleEventMetadata) {
            return this.approvalRuleEventMetadata((ApprovalRuleEventMetadata)((ApprovalRuleEventMetadata.Builder)ApprovalRuleEventMetadata.builder().applyMutation(approvalRuleEventMetadata)).build());
        }

        public Builder approvalStateChangedEventMetadata(ApprovalStateChangedEventMetadata var1);

        default public Builder approvalStateChangedEventMetadata(Consumer<ApprovalStateChangedEventMetadata.Builder> approvalStateChangedEventMetadata) {
            return this.approvalStateChangedEventMetadata((ApprovalStateChangedEventMetadata)((ApprovalStateChangedEventMetadata.Builder)ApprovalStateChangedEventMetadata.builder().applyMutation(approvalStateChangedEventMetadata)).build());
        }

        public Builder approvalRuleOverriddenEventMetadata(ApprovalRuleOverriddenEventMetadata var1);

        default public Builder approvalRuleOverriddenEventMetadata(Consumer<ApprovalRuleOverriddenEventMetadata.Builder> approvalRuleOverriddenEventMetadata) {
            return this.approvalRuleOverriddenEventMetadata((ApprovalRuleOverriddenEventMetadata)((ApprovalRuleOverriddenEventMetadata.Builder)ApprovalRuleOverriddenEventMetadata.builder().applyMutation(approvalRuleOverriddenEventMetadata)).build());
        }
    }
}

