/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse;

public class ListFileCommitHistoryPublisher
implements SdkPublisher<ListFileCommitHistoryResponse> {
    private final CodeCommitAsyncClient client;
    private final ListFileCommitHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFileCommitHistoryPublisher(CodeCommitAsyncClient client, ListFileCommitHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFileCommitHistoryPublisher(CodeCommitAsyncClient client, ListFileCommitHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFileCommitHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFileCommitHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFileCommitHistoryResponseFetcher
    implements AsyncPageFetcher<ListFileCommitHistoryResponse> {
        private ListFileCommitHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListFileCommitHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFileCommitHistoryResponse> nextPage(ListFileCommitHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListFileCommitHistoryPublisher.this.client.listFileCommitHistory(ListFileCommitHistoryPublisher.this.firstRequest);
            }
            return ListFileCommitHistoryPublisher.this.client.listFileCommitHistory((ListFileCommitHistoryRequest)((Object)ListFileCommitHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

