/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileModeTypeEnum {
    EXECUTABLE("EXECUTABLE"),
    NORMAL("NORMAL"),
    SYMLINK("SYMLINK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileModeTypeEnum> VALUE_MAP;
    private final String value;

    private FileModeTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileModeTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileModeTypeEnum> knownValues() {
        EnumSet<FileModeTypeEnum> knownValues = EnumSet.allOf(FileModeTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileModeTypeEnum.class, FileModeTypeEnum::toString);
    }
}

