/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.ReactionForComment;
import software.amazon.awssdk.services.codecommit.model.ReactionsForCommentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommentReactionsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetCommentReactionsResponse> {
    private static final SdkField<List<ReactionForComment>> REACTIONS_FOR_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reactionsForComment").getter(GetCommentReactionsResponse.getter(GetCommentReactionsResponse::reactionsForComment)).setter(GetCommentReactionsResponse.setter(Builder::reactionsForComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionsForComment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReactionForComment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetCommentReactionsResponse.getter(GetCommentReactionsResponse::nextToken)).setter(GetCommentReactionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTIONS_FOR_COMMENT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCommentReactionsResponse.memberNameToFieldInitializer();
    private final List<ReactionForComment> reactionsForComment;
    private final String nextToken;

    private GetCommentReactionsResponse(BuilderImpl builder) {
        super(builder);
        this.reactionsForComment = builder.reactionsForComment;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReactionsForComment() {
        return this.reactionsForComment != null && !(this.reactionsForComment instanceof SdkAutoConstructList);
    }

    public final List<ReactionForComment> reactionsForComment() {
        return this.reactionsForComment;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactionsForComment() ? this.reactionsForComment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentReactionsResponse)) {
            return false;
        }
        GetCommentReactionsResponse other = (GetCommentReactionsResponse)((Object)obj);
        return this.hasReactionsForComment() == other.hasReactionsForComment() && Objects.equals(this.reactionsForComment(), other.reactionsForComment()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommentReactionsResponse").add("ReactionsForComment", this.hasReactionsForComment() ? this.reactionsForComment() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reactionsForComment": {
                return Optional.ofNullable(clazz.cast(this.reactionsForComment()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reactionsForComment", REACTIONS_FOR_COMMENT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommentReactionsResponse, T> g) {
        return obj -> g.apply((GetCommentReactionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<ReactionForComment> reactionsForComment = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentReactionsResponse model) {
            super(model);
            this.reactionsForComment(model.reactionsForComment);
            this.nextToken(model.nextToken);
        }

        public final List<ReactionForComment.Builder> getReactionsForComment() {
            List<ReactionForComment.Builder> result = ReactionsForCommentListCopier.copyToBuilder(this.reactionsForComment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactionsForComment(Collection<ReactionForComment.BuilderImpl> reactionsForComment) {
            this.reactionsForComment = ReactionsForCommentListCopier.copyFromBuilder(reactionsForComment);
        }

        @Override
        public final Builder reactionsForComment(Collection<ReactionForComment> reactionsForComment) {
            this.reactionsForComment = ReactionsForCommentListCopier.copy(reactionsForComment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsForComment(ReactionForComment ... reactionsForComment) {
            this.reactionsForComment(Arrays.asList(reactionsForComment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsForComment(Consumer<ReactionForComment.Builder> ... reactionsForComment) {
            this.reactionsForComment(Stream.of(reactionsForComment).map(c -> (ReactionForComment)((ReactionForComment.Builder)ReactionForComment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCommentReactionsResponse build() {
            return new GetCommentReactionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommentReactionsResponse> {
        public Builder reactionsForComment(Collection<ReactionForComment> var1);

        public Builder reactionsForComment(ReactionForComment ... var1);

        public Builder reactionsForComment(Consumer<ReactionForComment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

