/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package software.amazon.awssdk.codegen.validation;

public enum ValidationErrorId {
    SHARED_MODELS_DIFFER(
        "The shared models between two services differ in their definition, which causes differences in the source"
        + " files generated by the code generator."
    ),
    UNKNOWN_SHAPE_MEMBER("The model references an unknown shape member."),
    REQUEST_URI_NOT_FOUND("The request URI does not exist."),

    INVALID_CODEGEN_CUSTOMIZATION("A customization is enabled for this service that cannot be applied for the given service "
                                  + "model.")
    ;

    private final String description;

    ValidationErrorId(String description) {
        this.description = description;
    }


}
