/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.service.Location;

public class AuthorizerModel
extends DocumentationModel {
    private final String name;
    private final String interfaceName;
    private final Location authTokenLocation;
    private final String tokenName;

    public AuthorizerModel(String name, String interfaceName, Location authTokenLocation, String tokenName) {
        this.name = name;
        this.interfaceName = interfaceName;
        this.authTokenLocation = authTokenLocation;
        this.tokenName = tokenName;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTokenPlacement() {
        return this.tokenName != null && this.authTokenLocation != null;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public Location getAuthTokenLocation() {
        return this.authTokenLocation;
    }

    @JsonIgnore
    public String getAddAuthTokenMethod() {
        switch (this.authTokenLocation) {
            case HEADER: {
                return "addHeader";
            }
            case QUERY_STRING: {
                return "addParameter";
            }
        }
        throw new IllegalArgumentException(String.format("Unhandled Location type for Auth Token Location '%s'", new Object[]{this.authTokenLocation}));
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthorizerModel that = (AuthorizerModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.interfaceName, that.interfaceName) && this.authTokenLocation == that.authTokenLocation && Objects.equals(this.tokenName, that.tokenName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.interfaceName);
        result = 31 * result + Objects.hashCode((Object)this.authTokenLocation);
        result = 31 * result + Objects.hashCode(this.tokenName);
        return result;
    }
}

