/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.validation.ValidationEntry;

public class ModelInvalidException
extends RuntimeException {
    private final List<ValidationEntry> validationEntries;

    private ModelInvalidException(Builder b) {
        super("Validation failed with the following errors: " + b.validationEntries);
        this.validationEntries = Collections.unmodifiableList(new ArrayList(b.validationEntries));
    }

    public List<ValidationEntry> validationEntries() {
        return this.validationEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelInvalidException fromEntry(ValidationEntry entry) {
        return ModelInvalidException.builder().validationEntries(Collections.singletonList(entry)).build();
    }

    public static class Builder {
        private List<ValidationEntry> validationEntries;

        public Builder validationEntries(List<ValidationEntry> validationEntries) {
            this.validationEntries = validationEntries == null ? Collections.emptyList() : validationEntries;
            return this;
        }

        public ModelInvalidException build() {
            return new ModelInvalidException(this);
        }
    }
}

