/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionOption {
    AWS_OWNED_CMK("AWS_OWNED_CMK"),
    CUSTOMER_MANAGED_CMK("CUSTOMER_MANAGED_CMK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionOption> VALUE_MAP;
    private final String value;

    private EncryptionOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionOption> knownValues() {
        EnumSet<EncryptionOption> knownValues = EnumSet.allOf(EncryptionOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionOption.class, EncryptionOption::toString);
    }
}

