/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.RuleTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleMetadata> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(RuleMetadata.getter(RuleMetadata::ruleId)).setter(RuleMetadata.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(RuleMetadata.getter(RuleMetadata::ruleName)).setter(RuleMetadata.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShortDescription").getter(RuleMetadata.getter(RuleMetadata::shortDescription)).setter(RuleMetadata.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()}).build();
    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongDescription").getter(RuleMetadata.getter(RuleMetadata::longDescription)).setter(RuleMetadata.setter(Builder::longDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongDescription").build()}).build();
    private static final SdkField<List<String>> RULE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleTags").getter(RuleMetadata.getter(RuleMetadata::ruleTags)).setter(RuleMetadata.setter(Builder::ruleTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, RULE_NAME_FIELD, SHORT_DESCRIPTION_FIELD, LONG_DESCRIPTION_FIELD, RULE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final String ruleName;
    private final String shortDescription;
    private final String longDescription;
    private final List<String> ruleTags;

    private RuleMetadata(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.ruleName = builder.ruleName;
        this.shortDescription = builder.shortDescription;
        this.longDescription = builder.longDescription;
        this.ruleTags = builder.ruleTags;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String shortDescription() {
        return this.shortDescription;
    }

    public final String longDescription() {
        return this.longDescription;
    }

    public final boolean hasRuleTags() {
        return this.ruleTags != null && !(this.ruleTags instanceof SdkAutoConstructList);
    }

    public final List<String> ruleTags() {
        return this.ruleTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleTags() ? this.ruleTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleMetadata)) {
            return false;
        }
        RuleMetadata other = (RuleMetadata)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.longDescription(), other.longDescription()) && this.hasRuleTags() == other.hasRuleTags() && Objects.equals(this.ruleTags(), other.ruleTags());
    }

    public final String toString() {
        return ToString.builder((String)"RuleMetadata").add("RuleId", (Object)this.ruleId()).add("RuleName", (Object)this.ruleName()).add("ShortDescription", (Object)this.shortDescription()).add("LongDescription", (Object)this.longDescription()).add("RuleTags", this.hasRuleTags() ? this.ruleTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "ShortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "LongDescription": {
                return Optional.ofNullable(clazz.cast(this.longDescription()));
            }
            case "RuleTags": {
                return Optional.ofNullable(clazz.cast(this.ruleTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("ShortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("LongDescription", LONG_DESCRIPTION_FIELD);
        map.put("RuleTags", RULE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleMetadata, T> g) {
        return obj -> g.apply((RuleMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String ruleName;
        private String shortDescription;
        private String longDescription;
        private List<String> ruleTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleMetadata model) {
            this.ruleId(model.ruleId);
            this.ruleName(model.ruleName);
            this.shortDescription(model.shortDescription);
            this.longDescription(model.longDescription);
            this.ruleTags(model.ruleTags);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getLongDescription() {
            return this.longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final Collection<String> getRuleTags() {
            if (this.ruleTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleTags;
        }

        public final void setRuleTags(Collection<String> ruleTags) {
            this.ruleTags = RuleTagsCopier.copy(ruleTags);
        }

        @Override
        public final Builder ruleTags(Collection<String> ruleTags) {
            this.ruleTags = RuleTagsCopier.copy(ruleTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleTags(String ... ruleTags) {
            this.ruleTags(Arrays.asList(ruleTags));
            return this;
        }

        public RuleMetadata build() {
            return new RuleMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleMetadata> {
        public Builder ruleId(String var1);

        public Builder ruleName(String var1);

        public Builder shortDescription(String var1);

        public Builder longDescription(String var1);

        public Builder ruleTags(Collection<String> var1);

        public Builder ruleTags(String ... var1);
    }
}

