/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.EncryptionOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KMSKeyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KMSKeyDetails> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(KMSKeyDetails.getter(KMSKeyDetails::kmsKeyId)).setter(KMSKeyDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<String> ENCRYPTION_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionOption").getter(KMSKeyDetails.getter(KMSKeyDetails::encryptionOptionAsString)).setter(KMSKeyDetails.setter(Builder::encryptionOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, ENCRYPTION_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KMSKeyDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String encryptionOption;

    private KMSKeyDetails(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptionOption = builder.encryptionOption;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final EncryptionOption encryptionOption() {
        return EncryptionOption.fromValue(this.encryptionOption);
    }

    public final String encryptionOptionAsString() {
        return this.encryptionOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSKeyDetails)) {
            return false;
        }
        KMSKeyDetails other = (KMSKeyDetails)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.encryptionOptionAsString(), other.encryptionOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KMSKeyDetails").add("KMSKeyId", (Object)this.kmsKeyId()).add("EncryptionOption", (Object)this.encryptionOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EncryptionOption": {
                return Optional.ofNullable(clazz.cast(this.encryptionOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("EncryptionOption", ENCRYPTION_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KMSKeyDetails, T> g) {
        return obj -> g.apply((KMSKeyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String encryptionOption;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSKeyDetails model) {
            this.kmsKeyId(model.kmsKeyId);
            this.encryptionOption(model.encryptionOption);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getEncryptionOption() {
            return this.encryptionOption;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        @Override
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        public final Builder encryptionOption(EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption == null ? null : encryptionOption.toString());
            return this;
        }

        public KMSKeyDetails build() {
            return new KMSKeyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KMSKeyDetails> {
        public Builder kmsKeyId(String var1);

        public Builder encryptionOption(String var1);

        public Builder encryptionOption(EncryptionOption var1);
    }
}

