/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary;

public class ListRepositoryAssociationsIterable
implements SdkIterable<ListRepositoryAssociationsResponse> {
    private final CodeGuruReviewerClient client;
    private final ListRepositoryAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositoryAssociationsIterable(CodeGuruReviewerClient client, ListRepositoryAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRepositoryAssociationsResponseFetcher();
    }

    public Iterator<ListRepositoryAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositoryAssociationSummary> repositoryAssociationSummaries() {
        Function<ListRepositoryAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositoryAssociationSummaries() != null) {
                return response.repositoryAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRepositoryAssociationsResponseFetcher
    implements SyncPageFetcher<ListRepositoryAssociationsResponse> {
        private ListRepositoryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositoryAssociationsResponse nextPage(ListRepositoryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoryAssociationsIterable.this.client.listRepositoryAssociations(ListRepositoryAssociationsIterable.this.firstRequest);
            }
            return ListRepositoryAssociationsIterable.this.client.listRepositoryAssociations((ListRepositoryAssociationsRequest)((Object)ListRepositoryAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

