/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClient;
import software.amazon.awssdk.services.codegurusecurity.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ScanSummary;

public class ListScansIterable
implements SdkIterable<ListScansResponse> {
    private final CodeGuruSecurityClient client;
    private final ListScansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScansIterable(CodeGuruSecurityClient client, ListScansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScansResponseFetcher();
    }

    public Iterator<ListScansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScanSummary> summaries() {
        Function<ListScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScansResponseFetcher
    implements SyncPageFetcher<ListScansResponse> {
        private ListScansResponseFetcher() {
        }

        public boolean hasNextPage(ListScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScansResponse nextPage(ListScansResponse previousPage) {
            if (previousPage == null) {
                return ListScansIterable.this.client.listScans(ListScansIterable.this.firstRequest);
            }
            return ListScansIterable.this.client.listScans((ListScansRequest)((Object)ListScansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

