/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConditionExecutionStatus {
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    ERRORED("Errored"),
    SUCCEEDED("Succeeded"),
    CANCELLED("Cancelled"),
    ABANDONED("Abandoned"),
    OVERRIDDEN("Overridden"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConditionExecutionStatus> VALUE_MAP;
    private final String value;

    private ConditionExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConditionExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConditionExecutionStatus> knownValues() {
        EnumSet<ConditionExecutionStatus> knownValues = EnumSet.allOf(ConditionExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConditionExecutionStatus.class, ConditionExecutionStatus::toString);
    }
}

