/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ActionType;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;

public class ListActionTypesPublisher
implements SdkPublisher<ListActionTypesResponse> {
    private final CodePipelineAsyncClient client;
    private final ListActionTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActionTypesPublisher(CodePipelineAsyncClient client, ListActionTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActionTypesPublisher(CodePipelineAsyncClient client, ListActionTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActionTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActionTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionType> actionTypes() {
        Function<ListActionTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionTypes() != null) {
                return response.actionTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActionTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActionTypesResponseFetcher
    implements AsyncPageFetcher<ListActionTypesResponse> {
        private ListActionTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListActionTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActionTypesResponse> nextPage(ListActionTypesResponse previousPage) {
            if (previousPage == null) {
                return ListActionTypesPublisher.this.client.listActionTypes(ListActionTypesPublisher.this.firstRequest);
            }
            return ListActionTypesPublisher.this.client.listActionTypes((ListActionTypesRequest)((Object)ListActionTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

