/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.DeployActionExecutionTarget;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsResponse;

public class ListDeployActionExecutionTargetsIterable
implements SdkIterable<ListDeployActionExecutionTargetsResponse> {
    private final CodePipelineClient client;
    private final ListDeployActionExecutionTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeployActionExecutionTargetsIterable(CodePipelineClient client, ListDeployActionExecutionTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeployActionExecutionTargetsResponseFetcher();
    }

    public Iterator<ListDeployActionExecutionTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeployActionExecutionTarget> targets() {
        Function<ListDeployActionExecutionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeployActionExecutionTargetsResponseFetcher
    implements SyncPageFetcher<ListDeployActionExecutionTargetsResponse> {
        private ListDeployActionExecutionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeployActionExecutionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeployActionExecutionTargetsResponse nextPage(ListDeployActionExecutionTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListDeployActionExecutionTargetsIterable.this.client.listDeployActionExecutionTargets(ListDeployActionExecutionTargetsIterable.this.firstRequest);
            }
            return ListDeployActionExecutionTargetsIterable.this.client.listDeployActionExecutionTargets((ListDeployActionExecutionTargetsRequest)((Object)ListDeployActionExecutionTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

