/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DetailType;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeIdsCopier;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus;
import software.amazon.awssdk.services.codestarnotifications.model.TagsCopier;
import software.amazon.awssdk.services.codestarnotifications.model.Target;
import software.amazon.awssdk.services.codestarnotifications.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNotificationRuleRequest
extends CodestarNotificationsRequest
implements ToCopyableBuilder<Builder, CreateNotificationRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::name)).setter(CreateNotificationRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTypeIds").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::eventTypeIds)).setter(CreateNotificationRuleRequest.setter(Builder::eventTypeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resource").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::resource)).setter(CreateNotificationRuleRequest.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::targets)).setter(CreateNotificationRuleRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailType").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::detailTypeAsString)).setter(CreateNotificationRuleRequest.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::clientRequestToken)).setter(CreateNotificationRuleRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::tags)).setter(CreateNotificationRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateNotificationRuleRequest.getter(CreateNotificationRuleRequest::statusAsString)).setter(CreateNotificationRuleRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EVENT_TYPE_IDS_FIELD, RESOURCE_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNotificationRuleRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<String> eventTypeIds;
    private final String resource;
    private final List<Target> targets;
    private final String detailType;
    private final String clientRequestToken;
    private final Map<String, String> tags;
    private final String status;

    private CreateNotificationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.eventTypeIds = builder.eventTypeIds;
        this.resource = builder.resource;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.status = builder.status;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasEventTypeIds() {
        return this.eventTypeIds != null && !(this.eventTypeIds instanceof SdkAutoConstructList);
    }

    public final List<String> eventTypeIds() {
        return this.eventTypeIds;
    }

    public final String resource() {
        return this.resource;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final DetailType detailType() {
        return DetailType.fromValue(this.detailType);
    }

    public final String detailTypeAsString() {
        return this.detailType;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypeIds() ? this.eventTypeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationRuleRequest)) {
            return false;
        }
        CreateNotificationRuleRequest other = (CreateNotificationRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasEventTypeIds() == other.hasEventTypeIds() && Objects.equals(this.eventTypeIds(), other.eventTypeIds()) && Objects.equals(this.resource(), other.resource()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.detailTypeAsString(), other.detailTypeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNotificationRuleRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTypeIds", this.hasEventTypeIds() ? this.eventTypeIds() : null).add("Resource", (Object)this.resource()).add("Targets", this.hasTargets() ? this.targets() : null).add("DetailType", (Object)this.detailTypeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EventTypeIds": {
                return Optional.ofNullable(clazz.cast(this.eventTypeIds()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailTypeAsString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("EventTypeIds", EVENT_TYPE_IDS_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationRuleRequest, T> g) {
        return obj -> g.apply((CreateNotificationRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> eventTypeIds = DefaultSdkAutoConstructList.getInstance();
        private String resource;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String detailType;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationRuleRequest model) {
            super(model);
            this.name(model.name);
            this.eventTypeIds(model.eventTypeIds);
            this.resource(model.resource);
            this.targets(model.targets);
            this.detailType(model.detailType);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.status(model.status);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEventTypeIds() {
            if (this.eventTypeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTypeIds;
        }

        public final void setEventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
        }

        @Override
        public final Builder eventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeIds(String ... eventTypeIds) {
            this.eventTypeIds(Arrays.asList(eventTypeIds));
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailType() {
            return this.detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationRuleRequest build() {
            return new CreateNotificationRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodestarNotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNotificationRuleRequest> {
        public Builder name(String var1);

        public Builder eventTypeIds(Collection<String> var1);

        public Builder eventTypeIds(String ... var1);

        public Builder resource(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder detailType(String var1);

        public Builder detailType(DetailType var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(NotificationRuleStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

