/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the ListIdentities action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentitiesRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<ListIdentitiesRequest.Builder, ListIdentitiesRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(ListIdentitiesRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListIdentitiesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> HIDE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HideDisabled").getter(getter(ListIdentitiesRequest::hideDisabled)).setter(setter(Builder::hideDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HideDisabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, HIDE_DISABLED_FIELD));

    private final String identityPoolId;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean hideDisabled;

    private ListIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.hideDisabled = builder.hideDisabled;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The maximum number of identities to return.
     * </p>
     * 
     * @return The maximum number of identities to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API
     * will include disabled identities in the response.
     * </p>
     * 
     * @return An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities
     *         API will include disabled identities in the response.
     */
    public final Boolean hideDisabled() {
        return hideDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hideDisabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(hideDisabled(), other.hideDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentitiesRequest").add("IdentityPoolId", identityPoolId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("HideDisabled", hideDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "HideDisabled":
            return Optional.ofNullable(clazz.cast(hideDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitiesRequest, T> g) {
        return obj -> g.apply((ListIdentitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIdentitiesRequest> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The maximum number of identities to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of identities to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API
         * will include disabled identities in the response.
         * </p>
         * 
         * @param hideDisabled
         *        An optional boolean parameter that allows you to hide disabled identities. If omitted, the
         *        ListIdentities API will include disabled identities in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hideDisabled(Boolean hideDisabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private Integer maxResults;

        private String nextToken;

        private Boolean hideDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            hideDisabled(model.hideDisabled);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getHideDisabled() {
            return hideDisabled;
        }

        public final void setHideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
        }

        @Override
        @Transient
        public final Builder hideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
