/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsConfigurationType> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(AnalyticsConfigurationType.getter(AnalyticsConfigurationType::applicationId)).setter(AnalyticsConfigurationType.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(AnalyticsConfigurationType.getter(AnalyticsConfigurationType::applicationArn)).setter(AnalyticsConfigurationType.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AnalyticsConfigurationType.getter(AnalyticsConfigurationType::roleArn)).setter(AnalyticsConfigurationType.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(AnalyticsConfigurationType.getter(AnalyticsConfigurationType::externalId)).setter(AnalyticsConfigurationType.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final SdkField<Boolean> USER_DATA_SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserDataShared").getter(AnalyticsConfigurationType.getter(AnalyticsConfigurationType::userDataShared)).setter(AnalyticsConfigurationType.setter(Builder::userDataShared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDataShared").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_ARN_FIELD, ROLE_ARN_FIELD, EXTERNAL_ID_FIELD, USER_DATA_SHARED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyticsConfigurationType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String applicationArn;
    private final String roleArn;
    private final String externalId;
    private final Boolean userDataShared;

    private AnalyticsConfigurationType(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.roleArn = builder.roleArn;
        this.externalId = builder.externalId;
        this.userDataShared = builder.userDataShared;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final Boolean userDataShared() {
        return this.userDataShared;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userDataShared());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsConfigurationType)) {
            return false;
        }
        AnalyticsConfigurationType other = (AnalyticsConfigurationType)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.userDataShared(), other.userDataShared());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsConfigurationType").add("ApplicationId", (Object)this.applicationId()).add("ApplicationArn", (Object)this.applicationArn()).add("RoleArn", (Object)this.roleArn()).add("ExternalId", (Object)this.externalId()).add("UserDataShared", (Object)this.userDataShared()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "UserDataShared": {
                return Optional.ofNullable(clazz.cast(this.userDataShared()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ExternalId", EXTERNAL_ID_FIELD);
        map.put("UserDataShared", USER_DATA_SHARED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsConfigurationType, T> g) {
        return obj -> g.apply((AnalyticsConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationArn;
        private String roleArn;
        private String externalId;
        private Boolean userDataShared;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsConfigurationType model) {
            this.applicationId(model.applicationId);
            this.applicationArn(model.applicationArn);
            this.roleArn(model.roleArn);
            this.externalId(model.externalId);
            this.userDataShared(model.userDataShared);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Boolean getUserDataShared() {
            return this.userDataShared;
        }

        public final void setUserDataShared(Boolean userDataShared) {
            this.userDataShared = userDataShared;
        }

        @Override
        public final Builder userDataShared(Boolean userDataShared) {
            this.userDataShared = userDataShared;
            return this;
        }

        public AnalyticsConfigurationType build() {
            return new AnalyticsConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsConfigurationType> {
        public Builder applicationId(String var1);

        public Builder applicationArn(String var1);

        public Builder roleArn(String var1);

        public Builder externalId(String var1);

        public Builder userDataShared(Boolean var1);
    }
}

