/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricSourceProvider {
    CLOUD_WATCH_APPLICATION_INSIGHTS("CloudWatchApplicationInsights"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricSourceProvider> VALUE_MAP;
    private final String value;

    private MetricSourceProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricSourceProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricSourceProvider> knownValues() {
        EnumSet<MetricSourceProvider> knownValues = EnumSet.allOf(MetricSourceProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricSourceProvider.class, MetricSourceProvider::toString);
    }
}

