/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlatformDifference {
    HYPERVISOR("Hypervisor"),
    NETWORK_INTERFACE("NetworkInterface"),
    STORAGE_INTERFACE("StorageInterface"),
    INSTANCE_STORE_AVAILABILITY("InstanceStoreAvailability"),
    VIRTUALIZATION_TYPE("VirtualizationType"),
    ARCHITECTURE("Architecture"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlatformDifference> VALUE_MAP;
    private final String value;

    private PlatformDifference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformDifference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformDifference> knownValues() {
        EnumSet<PlatformDifference> knownValues = EnumSet.allOf(PlatformDifference.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlatformDifference.class, PlatformDifference::toString);
    }
}

