/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferredWorkloadSaving
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferredWorkloadSaving> {
    private static final SdkField<List<String>> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferredWorkloadTypes").getter(InferredWorkloadSaving.getter(InferredWorkloadSaving::inferredWorkloadTypesAsStrings)).setter(InferredWorkloadSaving.setter(Builder::inferredWorkloadTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings").getter(InferredWorkloadSaving.getter(InferredWorkloadSaving::estimatedMonthlySavings)).setter(InferredWorkloadSaving.setter(Builder::estimatedMonthlySavings)).constructor(EstimatedMonthlySavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERRED_WORKLOAD_TYPES_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferredWorkloadSaving.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> inferredWorkloadTypes;
    private final EstimatedMonthlySavings estimatedMonthlySavings;

    private InferredWorkloadSaving(BuilderImpl builder) {
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    public final List<InferredWorkloadType> inferredWorkloadTypes() {
        return InferredWorkloadTypesCopier.copyStringToEnum(this.inferredWorkloadTypes);
    }

    public final boolean hasInferredWorkloadTypes() {
        return this.inferredWorkloadTypes != null && !(this.inferredWorkloadTypes instanceof SdkAutoConstructList);
    }

    public final List<String> inferredWorkloadTypesAsStrings() {
        return this.inferredWorkloadTypes;
    }

    public final EstimatedMonthlySavings estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferredWorkloadSaving)) {
            return false;
        }
        InferredWorkloadSaving other = (InferredWorkloadSaving)obj;
        return this.hasInferredWorkloadTypes() == other.hasInferredWorkloadTypes() && Objects.equals(this.inferredWorkloadTypesAsStrings(), other.inferredWorkloadTypesAsStrings()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    public final String toString() {
        return ToString.builder((String)"InferredWorkloadSaving").add("InferredWorkloadTypes", this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsStrings()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inferredWorkloadTypes", INFERRED_WORKLOAD_TYPES_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferredWorkloadSaving, T> g) {
        return obj -> g.apply((InferredWorkloadSaving)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> inferredWorkloadTypes = DefaultSdkAutoConstructList.getInstance();
        private EstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(InferredWorkloadSaving model) {
            this.inferredWorkloadTypesWithStrings(model.inferredWorkloadTypes);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final Collection<String> getInferredWorkloadTypes() {
            if (this.inferredWorkloadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
        }

        @Override
        public final Builder inferredWorkloadTypesWithStrings(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypesWithStrings(String ... inferredWorkloadTypes) {
            this.inferredWorkloadTypesWithStrings(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(Collection<InferredWorkloadType> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copyEnumToString(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypes(InferredWorkloadType ... inferredWorkloadTypes) {
            this.inferredWorkloadTypes(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        public final EstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings != null ? this.estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(EstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public InferredWorkloadSaving build() {
            return new InferredWorkloadSaving(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferredWorkloadSaving> {
        public Builder inferredWorkloadTypesWithStrings(Collection<String> var1);

        public Builder inferredWorkloadTypesWithStrings(String ... var1);

        public Builder inferredWorkloadTypes(Collection<InferredWorkloadType> var1);

        public Builder inferredWorkloadTypes(InferredWorkloadType ... var1);

        public Builder estimatedMonthlySavings(EstimatedMonthlySavings var1);

        default public Builder estimatedMonthlySavings(Consumer<EstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return this.estimatedMonthlySavings((EstimatedMonthlySavings)((EstimatedMonthlySavings.Builder)EstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)).build());
        }
    }
}

