/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatusesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnrollmentStatusesForOrganizationResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEnrollmentStatusesForOrganizationResponse> {
    private static final SdkField<List<AccountEnrollmentStatus>> ACCOUNT_ENROLLMENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountEnrollmentStatuses").getter(GetEnrollmentStatusesForOrganizationResponse.getter(GetEnrollmentStatusesForOrganizationResponse::accountEnrollmentStatuses)).setter(GetEnrollmentStatusesForOrganizationResponse.setter(Builder::accountEnrollmentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountEnrollmentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountEnrollmentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetEnrollmentStatusesForOrganizationResponse.getter(GetEnrollmentStatusesForOrganizationResponse::nextToken)).setter(GetEnrollmentStatusesForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ENROLLMENT_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEnrollmentStatusesForOrganizationResponse.memberNameToFieldInitializer();
    private final List<AccountEnrollmentStatus> accountEnrollmentStatuses;
    private final String nextToken;

    private GetEnrollmentStatusesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.accountEnrollmentStatuses = builder.accountEnrollmentStatuses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountEnrollmentStatuses() {
        return this.accountEnrollmentStatuses != null && !(this.accountEnrollmentStatuses instanceof SdkAutoConstructList);
    }

    public final List<AccountEnrollmentStatus> accountEnrollmentStatuses() {
        return this.accountEnrollmentStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountEnrollmentStatuses() ? this.accountEnrollmentStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusesForOrganizationResponse)) {
            return false;
        }
        GetEnrollmentStatusesForOrganizationResponse other = (GetEnrollmentStatusesForOrganizationResponse)((Object)obj);
        return this.hasAccountEnrollmentStatuses() == other.hasAccountEnrollmentStatuses() && Objects.equals(this.accountEnrollmentStatuses(), other.accountEnrollmentStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnrollmentStatusesForOrganizationResponse").add("AccountEnrollmentStatuses", this.hasAccountEnrollmentStatuses() ? this.accountEnrollmentStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountEnrollmentStatuses": {
                return Optional.ofNullable(clazz.cast(this.accountEnrollmentStatuses()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountEnrollmentStatuses", ACCOUNT_ENROLLMENT_STATUSES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusesForOrganizationResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusesForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private List<AccountEnrollmentStatus> accountEnrollmentStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusesForOrganizationResponse model) {
            super(model);
            this.accountEnrollmentStatuses(model.accountEnrollmentStatuses);
            this.nextToken(model.nextToken);
        }

        public final List<AccountEnrollmentStatus.Builder> getAccountEnrollmentStatuses() {
            List<AccountEnrollmentStatus.Builder> result = AccountEnrollmentStatusesCopier.copyToBuilder(this.accountEnrollmentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountEnrollmentStatuses(Collection<AccountEnrollmentStatus.BuilderImpl> accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses = AccountEnrollmentStatusesCopier.copyFromBuilder(accountEnrollmentStatuses);
        }

        @Override
        public final Builder accountEnrollmentStatuses(Collection<AccountEnrollmentStatus> accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses = AccountEnrollmentStatusesCopier.copy(accountEnrollmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountEnrollmentStatuses(AccountEnrollmentStatus ... accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses(Arrays.asList(accountEnrollmentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountEnrollmentStatuses(Consumer<AccountEnrollmentStatus.Builder> ... accountEnrollmentStatuses) {
            this.accountEnrollmentStatuses(Stream.of(accountEnrollmentStatuses).map(c -> (AccountEnrollmentStatus)((AccountEnrollmentStatus.Builder)AccountEnrollmentStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetEnrollmentStatusesForOrganizationResponse build() {
            return new GetEnrollmentStatusesForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnrollmentStatusesForOrganizationResponse> {
        public Builder accountEnrollmentStatuses(Collection<AccountEnrollmentStatus> var1);

        public Builder accountEnrollmentStatuses(AccountEnrollmentStatus ... var1);

        public Builder accountEnrollmentStatuses(Consumer<AccountEnrollmentStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

