/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSStorageFindingReasonCode {
    EBS_VOLUME_ALLOCATED_STORAGE_UNDERPROVISIONED("EBSVolumeAllocatedStorageUnderprovisioned"),
    EBS_VOLUME_THROUGHPUT_UNDERPROVISIONED("EBSVolumeThroughputUnderprovisioned"),
    EBS_VOLUME_IOPS_OVERPROVISIONED("EBSVolumeIOPSOverprovisioned"),
    EBS_VOLUME_THROUGHPUT_OVERPROVISIONED("EBSVolumeThroughputOverprovisioned"),
    NEW_GENERATION_STORAGE_TYPE_AVAILABLE("NewGenerationStorageTypeAvailable"),
    DB_CLUSTER_STORAGE_OPTION_AVAILABLE("DBClusterStorageOptionAvailable"),
    DB_CLUSTER_STORAGE_SAVINGS_AVAILABLE("DBClusterStorageSavingsAvailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSStorageFindingReasonCode> VALUE_MAP;
    private final String value;

    private RDSStorageFindingReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSStorageFindingReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSStorageFindingReasonCode> knownValues() {
        EnumSet<RDSStorageFindingReasonCode> knownValues = EnumSet.allOf(RDSStorageFindingReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSStorageFindingReasonCode.class, RDSStorageFindingReasonCode::toString);
    }
}

