/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventStep;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventStepsRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventStepsResponse;

public class ListAutomationEventStepsIterable
implements SdkIterable<ListAutomationEventStepsResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationEventStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationEventStepsIterable(ComputeOptimizerAutomationClient client, ListAutomationEventStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationEventStepsResponseFetcher();
    }

    public Iterator<ListAutomationEventStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomationEventStep> automationEventSteps() {
        Function<ListAutomationEventStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEventSteps() != null) {
                return response.automationEventSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationEventStepsResponseFetcher
    implements SyncPageFetcher<ListAutomationEventStepsResponse> {
        private ListAutomationEventStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationEventStepsResponse nextPage(ListAutomationEventStepsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventStepsIterable.this.client.listAutomationEventSteps(ListAutomationEventStepsIterable.this.firstRequest);
            }
            return ListAutomationEventStepsIterable.this.client.listAutomationEventSteps((ListAutomationEventStepsRequest)((Object)ListAutomationEventStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

