/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAggregateComplianceByConformancePacksResponse extends ConfigResponse
        implements
        ToCopyableBuilder<DescribeAggregateComplianceByConformancePacksResponse.Builder, DescribeAggregateComplianceByConformancePacksResponse> {
    private static final SdkField<List<AggregateComplianceByConformancePack>> AGGREGATE_COMPLIANCE_BY_CONFORMANCE_PACKS_FIELD = SdkField
            .<List<AggregateComplianceByConformancePack>> builder(MarshallingType.LIST)
            .memberName("AggregateComplianceByConformancePacks")
            .getter(getter(DescribeAggregateComplianceByConformancePacksResponse::aggregateComplianceByConformancePacks))
            .setter(setter(Builder::aggregateComplianceByConformancePacks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AggregateComplianceByConformancePacks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateComplianceByConformancePack> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateComplianceByConformancePack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAggregateComplianceByConformancePacksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATE_COMPLIANCE_BY_CONFORMANCE_PACKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AggregateComplianceByConformancePack> aggregateComplianceByConformancePacks;

    private final String nextToken;

    private DescribeAggregateComplianceByConformancePacksResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateComplianceByConformancePacks = builder.aggregateComplianceByConformancePacks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregateComplianceByConformancePacks
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAggregateComplianceByConformancePacks() {
        return aggregateComplianceByConformancePacks != null
                && !(aggregateComplianceByConformancePacks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the <code>AggregateComplianceByConformancePack</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregateComplianceByConformancePacks}
     * method.
     * </p>
     * 
     * @return Returns the <code>AggregateComplianceByConformancePack</code> object.
     */
    public final List<AggregateComplianceByConformancePack> aggregateComplianceByConformancePacks() {
        return aggregateComplianceByConformancePacks;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAggregateComplianceByConformancePacks() ? aggregateComplianceByConformancePacks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregateComplianceByConformancePacksResponse)) {
            return false;
        }
        DescribeAggregateComplianceByConformancePacksResponse other = (DescribeAggregateComplianceByConformancePacksResponse) obj;
        return hasAggregateComplianceByConformancePacks() == other.hasAggregateComplianceByConformancePacks()
                && Objects.equals(aggregateComplianceByConformancePacks(), other.aggregateComplianceByConformancePacks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAggregateComplianceByConformancePacksResponse")
                .add("AggregateComplianceByConformancePacks",
                        hasAggregateComplianceByConformancePacks() ? aggregateComplianceByConformancePacks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregateComplianceByConformancePacks":
            return Optional.ofNullable(clazz.cast(aggregateComplianceByConformancePacks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAggregateComplianceByConformancePacksResponse, T> g) {
        return obj -> g.apply((DescribeAggregateComplianceByConformancePacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAggregateComplianceByConformancePacksResponse> {
        /**
         * <p>
         * Returns the <code>AggregateComplianceByConformancePack</code> object.
         * </p>
         * 
         * @param aggregateComplianceByConformancePacks
         *        Returns the <code>AggregateComplianceByConformancePack</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceByConformancePacks(
                Collection<AggregateComplianceByConformancePack> aggregateComplianceByConformancePacks);

        /**
         * <p>
         * Returns the <code>AggregateComplianceByConformancePack</code> object.
         * </p>
         * 
         * @param aggregateComplianceByConformancePacks
         *        Returns the <code>AggregateComplianceByConformancePack</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceByConformancePacks(
                AggregateComplianceByConformancePack... aggregateComplianceByConformancePacks);

        /**
         * <p>
         * Returns the <code>AggregateComplianceByConformancePack</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #aggregateComplianceByConformancePacks(List<AggregateComplianceByConformancePack>)}.
         * 
         * @param aggregateComplianceByConformancePacks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateComplianceByConformancePacks(java.util.Collection<AggregateComplianceByConformancePack>)
         */
        Builder aggregateComplianceByConformancePacks(
                Consumer<AggregateComplianceByConformancePack.Builder>... aggregateComplianceByConformancePacks);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregateComplianceByConformancePack> aggregateComplianceByConformancePacks = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregateComplianceByConformancePacksResponse model) {
            super(model);
            aggregateComplianceByConformancePacks(model.aggregateComplianceByConformancePacks);
            nextToken(model.nextToken);
        }

        public final List<AggregateComplianceByConformancePack.Builder> getAggregateComplianceByConformancePacks() {
            List<AggregateComplianceByConformancePack.Builder> result = AggregateComplianceByConformancePackListCopier
                    .copyToBuilder(this.aggregateComplianceByConformancePacks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregateComplianceByConformancePacks(
                Collection<AggregateComplianceByConformancePack.BuilderImpl> aggregateComplianceByConformancePacks) {
            this.aggregateComplianceByConformancePacks = AggregateComplianceByConformancePackListCopier
                    .copyFromBuilder(aggregateComplianceByConformancePacks);
        }

        @Override
        public final Builder aggregateComplianceByConformancePacks(
                Collection<AggregateComplianceByConformancePack> aggregateComplianceByConformancePacks) {
            this.aggregateComplianceByConformancePacks = AggregateComplianceByConformancePackListCopier
                    .copy(aggregateComplianceByConformancePacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConformancePacks(
                AggregateComplianceByConformancePack... aggregateComplianceByConformancePacks) {
            aggregateComplianceByConformancePacks(Arrays.asList(aggregateComplianceByConformancePacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConformancePacks(
                Consumer<AggregateComplianceByConformancePack.Builder>... aggregateComplianceByConformancePacks) {
            aggregateComplianceByConformancePacks(Stream.of(aggregateComplianceByConformancePacks)
                    .map(c -> AggregateComplianceByConformancePack.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAggregateComplianceByConformancePacksResponse build() {
            return new DescribeAggregateComplianceByConformancePacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
