/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This API allows you to create a conformance pack template with an Amazon Web Services Systems Manager document (SSM
 * document). To deploy a conformance pack using an SSM document, first create an SSM document with conformance pack
 * content, and then provide the <code>DocumentName</code> in the <a
 * href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">PutConformancePack API</a>.
 * You can also provide the <code>DocumentVersion</code>.
 * </p>
 * <p>
 * The <code>TemplateSSMDocumentDetails</code> object contains the name of the SSM document and the version of the SSM
 * document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSSMDocumentDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateSSMDocumentDetails.Builder, TemplateSSMDocumentDetails> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(TemplateSSMDocumentDetails::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(TemplateSSMDocumentDetails::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD,
            DOCUMENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentName;

    private final String documentVersion;

    private TemplateSSMDocumentDetails(BuilderImpl builder) {
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the
     * document name, Config checks only your account and Amazon Web Services Region for the SSM document.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you
     *         use the document name, Config checks only your account and Amazon Web Services Region for the SSM
     *         document.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return The version of the SSM document to use to create a conformance pack. By default, Config uses the latest
     *         version.</p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String documentVersion() {
        return documentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSSMDocumentDetails)) {
            return false;
        }
        TemplateSSMDocumentDetails other = (TemplateSSMDocumentDetails) obj;
        return Objects.equals(documentName(), other.documentName()) && Objects.equals(documentVersion(), other.documentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateSSMDocumentDetails").add("DocumentName", documentName())
                .add("DocumentVersion", documentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSSMDocumentDetails, T> g) {
        return obj -> g.apply((TemplateSSMDocumentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSSMDocumentDetails> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use
         * the document name, Config checks only your account and Amazon Web Services Region for the SSM document.
         * </p>
         * 
         * @param documentName
         *        The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you
         *        use the document name, Config checks only your account and Amazon Web Services Region for the SSM
         *        document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the SSM document to use to create a conformance pack. By default, Config uses the latest
         * version.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param documentVersion
         *        The version of the SSM document to use to create a conformance pack. By default, Config uses the
         *        latest version.</p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String documentName;

        private String documentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSSMDocumentDetails model) {
            documentName(model.documentName);
            documentVersion(model.documentVersion);
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        @Override
        public TemplateSSMDocumentDetails build() {
            return new TemplateSSMDocumentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
