/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;

public class ListConfigurationRecordersPublisher
implements SdkPublisher<ListConfigurationRecordersResponse> {
    private final ConfigAsyncClient client;
    private final ListConfigurationRecordersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationRecordersPublisher(ConfigAsyncClient client, ListConfigurationRecordersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationRecordersPublisher(ConfigAsyncClient client, ListConfigurationRecordersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationRecordersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationRecordersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationRecorderSummary> configurationRecorderSummaries() {
        Function<ListConfigurationRecordersResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationRecorderSummaries() != null) {
                return response.configurationRecorderSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationRecordersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationRecordersResponseFetcher
    implements AsyncPageFetcher<ListConfigurationRecordersResponse> {
        private ListConfigurationRecordersResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationRecordersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationRecordersResponse> nextPage(ListConfigurationRecordersResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationRecordersPublisher.this.client.listConfigurationRecorders(ListConfigurationRecordersPublisher.this.firstRequest);
            }
            return ListConfigurationRecordersPublisher.this.client.listConfigurationRecorders((ListConfigurationRecordersRequest)((Object)ListConfigurationRecordersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

