/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateEvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateEvaluationResult> {
    private static final SdkField<EvaluationResultIdentifier> EVALUATION_RESULT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationResultIdentifier").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::evaluationResultIdentifier)).setter(AggregateEvaluationResult.setter(Builder::evaluationResultIdentifier)).constructor(EvaluationResultIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResultIdentifier").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::complianceTypeAsString)).setter(AggregateEvaluationResult.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<Instant> RESULT_RECORDED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResultRecordedTime").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::resultRecordedTime)).setter(AggregateEvaluationResult.setter(Builder::resultRecordedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRecordedTime").build()}).build();
    private static final SdkField<Instant> CONFIG_RULE_INVOKED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConfigRuleInvokedTime").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::configRuleInvokedTime)).setter(AggregateEvaluationResult.setter(Builder::configRuleInvokedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleInvokedTime").build()}).build();
    private static final SdkField<String> ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Annotation").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::annotation)).setter(AggregateEvaluationResult.setter(Builder::annotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::accountId)).setter(AggregateEvaluationResult.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(AggregateEvaluationResult.getter(AggregateEvaluationResult::awsRegion)).setter(AggregateEvaluationResult.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_IDENTIFIER_FIELD, COMPLIANCE_TYPE_FIELD, RESULT_RECORDED_TIME_FIELD, CONFIG_RULE_INVOKED_TIME_FIELD, ANNOTATION_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateEvaluationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationResultIdentifier evaluationResultIdentifier;
    private final String complianceType;
    private final Instant resultRecordedTime;
    private final Instant configRuleInvokedTime;
    private final String annotation;
    private final String accountId;
    private final String awsRegion;

    private AggregateEvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public final EvaluationResultIdentifier evaluationResultIdentifier() {
        return this.evaluationResultIdentifier;
    }

    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final Instant resultRecordedTime() {
        return this.resultRecordedTime;
    }

    public final Instant configRuleInvokedTime() {
        return this.configRuleInvokedTime;
    }

    public final String annotation() {
        return this.annotation;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateEvaluationResult)) {
            return false;
        }
        AggregateEvaluationResult other = (AggregateEvaluationResult)obj;
        return Objects.equals(this.evaluationResultIdentifier(), other.evaluationResultIdentifier()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.resultRecordedTime(), other.resultRecordedTime()) && Objects.equals(this.configRuleInvokedTime(), other.configRuleInvokedTime()) && Objects.equals(this.annotation(), other.annotation()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateEvaluationResult").add("EvaluationResultIdentifier", (Object)this.evaluationResultIdentifier()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("ResultRecordedTime", (Object)this.resultRecordedTime()).add("ConfigRuleInvokedTime", (Object)this.configRuleInvokedTime()).add("Annotation", (Object)this.annotation()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResultIdentifier": {
                return Optional.ofNullable(clazz.cast(this.evaluationResultIdentifier()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "ResultRecordedTime": {
                return Optional.ofNullable(clazz.cast(this.resultRecordedTime()));
            }
            case "ConfigRuleInvokedTime": {
                return Optional.ofNullable(clazz.cast(this.configRuleInvokedTime()));
            }
            case "Annotation": {
                return Optional.ofNullable(clazz.cast(this.annotation()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationResultIdentifier", EVALUATION_RESULT_IDENTIFIER_FIELD);
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("ResultRecordedTime", RESULT_RECORDED_TIME_FIELD);
        map.put("ConfigRuleInvokedTime", CONFIG_RULE_INVOKED_TIME_FIELD);
        map.put("Annotation", ANNOTATION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateEvaluationResult, T> g) {
        return obj -> g.apply((AggregateEvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;
        private String complianceType;
        private Instant resultRecordedTime;
        private Instant configRuleInvokedTime;
        private String annotation;
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateEvaluationResult model) {
            this.evaluationResultIdentifier(model.evaluationResultIdentifier);
            this.complianceType(model.complianceType);
            this.resultRecordedTime(model.resultRecordedTime);
            this.configRuleInvokedTime(model.configRuleInvokedTime);
            this.annotation(model.annotation);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return this.evaluationResultIdentifier != null ? this.evaluationResultIdentifier.toBuilder() : null;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final Instant getResultRecordedTime() {
            return this.resultRecordedTime;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final Instant getConfigRuleInvokedTime() {
            return this.configRuleInvokedTime;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public AggregateEvaluationResult build() {
            return new AggregateEvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateEvaluationResult> {
        public Builder evaluationResultIdentifier(EvaluationResultIdentifier var1);

        default public Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return this.evaluationResultIdentifier((EvaluationResultIdentifier)((EvaluationResultIdentifier.Builder)EvaluationResultIdentifier.builder().applyMutation(evaluationResultIdentifier)).build());
        }

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder resultRecordedTime(Instant var1);

        public Builder configRuleInvokedTime(Instant var1);

        public Builder annotation(String var1);

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

