/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConformancePackStatusDetail;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;

public class DescribeConformancePackStatusPublisher
implements SdkPublisher<DescribeConformancePackStatusResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConformancePackStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConformancePackStatusPublisher(ConfigAsyncClient client, DescribeConformancePackStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConformancePackStatusPublisher(ConfigAsyncClient client, DescribeConformancePackStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConformancePackStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConformancePackStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConformancePackStatusDetail> conformancePackStatusDetails() {
        return this.flatMapIterable(response -> response.conformancePackStatusDetails());
    }

    private class DescribeConformancePackStatusResponseFetcher
    implements AsyncPageFetcher<DescribeConformancePackStatusResponse> {
        private DescribeConformancePackStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConformancePackStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConformancePackStatusResponse> nextPage(DescribeConformancePackStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConformancePackStatusPublisher.this.client.describeConformancePackStatus(DescribeConformancePackStatusPublisher.this.firstRequest);
            }
            return DescribeConformancePackStatusPublisher.this.client.describeConformancePackStatus((DescribeConformancePackStatusRequest)((Object)DescribeConformancePackStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

