/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;

public class GetAggregateDiscoveredResourceCountsPublisher
implements SdkPublisher<GetAggregateDiscoveredResourceCountsResponse> {
    private final ConfigAsyncClient client;
    private final GetAggregateDiscoveredResourceCountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAggregateDiscoveredResourceCountsPublisher(ConfigAsyncClient client, GetAggregateDiscoveredResourceCountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAggregateDiscoveredResourceCountsPublisher(ConfigAsyncClient client, GetAggregateDiscoveredResourceCountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAggregateDiscoveredResourceCountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAggregateDiscoveredResourceCountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetAggregateDiscoveredResourceCountsResponseFetcher
    implements AsyncPageFetcher<GetAggregateDiscoveredResourceCountsResponse> {
        private GetAggregateDiscoveredResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetAggregateDiscoveredResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> nextPage(GetAggregateDiscoveredResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetAggregateDiscoveredResourceCountsPublisher.this.client.getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsPublisher.this.firstRequest);
            }
            return GetAggregateDiscoveredResourceCountsPublisher.this.client.getAggregateDiscoveredResourceCounts((GetAggregateDiscoveredResourceCountsRequest)((Object)GetAggregateDiscoveredResourceCountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

