/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus;

public class DescribeOrganizationConfigRuleStatusesPublisher
implements SdkPublisher<DescribeOrganizationConfigRuleStatusesResponse> {
    private final ConfigAsyncClient client;
    private final DescribeOrganizationConfigRuleStatusesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrganizationConfigRuleStatusesPublisher(ConfigAsyncClient client, DescribeOrganizationConfigRuleStatusesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrganizationConfigRuleStatusesPublisher(ConfigAsyncClient client, DescribeOrganizationConfigRuleStatusesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrganizationConfigRuleStatusesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrganizationConfigRuleStatusesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationConfigRuleStatus> organizationConfigRuleStatuses() {
        return this.flatMapIterable(response -> response.organizationConfigRuleStatuses());
    }

    private class DescribeOrganizationConfigRuleStatusesResponseFetcher
    implements AsyncPageFetcher<DescribeOrganizationConfigRuleStatusesResponse> {
        private DescribeOrganizationConfigRuleStatusesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConfigRuleStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> nextPage(DescribeOrganizationConfigRuleStatusesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConfigRuleStatusesPublisher.this.client.describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesPublisher.this.firstRequest);
            }
            return DescribeOrganizationConfigRuleStatusesPublisher.this.client.describeOrganizationConfigRuleStatuses((DescribeOrganizationConfigRuleStatusesRequest)((Object)DescribeOrganizationConfigRuleStatusesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

